/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.transport.PortOccupiedException;
import com.predic8.membrane.core.transport.http.HttpServerHandler;
import com.predic8.membrane.core.transport.http.HttpTransport;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.InvalidParameterException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpEndpointListener
extends Thread {
    private static final Logger log = LoggerFactory.getLogger((String)HttpEndpointListener.class.getName());
    private final ServerSocket serverSocket;
    private final HttpTransport transport;
    private final SSLProvider sslProvider;
    private final ConcurrentHashMap<Socket, Boolean> idleSockets = new ConcurrentHashMap();
    private final ConcurrentHashMap<Socket, Boolean> openSockets = new ConcurrentHashMap();
    private volatile boolean closed;

    public HttpEndpointListener(String ip, int port, HttpTransport transport, SSLProvider sslProvider) throws IOException {
        this.transport = transport;
        this.sslProvider = sslProvider;
        try {
            this.serverSocket = sslProvider != null ? sslProvider.createServerSocket(port, 50, ip != null ? InetAddress.getByName(ip) : null) : new ServerSocket(port, 50, ip != null ? InetAddress.getByName(ip) : null);
            this.setName("Connection Acceptor " + (ip != null ? ip + ":" : ":") + port);
            log.debug("listening at port " + port + (ip != null ? " ip " + ip : ""));
        }
        catch (BindException e) {
            throw new PortOccupiedException(port);
        }
    }

    @Override
    public void run() {
        while (!this.closed) {
            try {
                Socket socket = this.serverSocket.accept();
                this.openSockets.put(socket, Boolean.TRUE);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Accepted connection from " + socket.getRemoteSocketAddress());
                    }
                    this.transport.getExecutorService().execute(new HttpServerHandler(socket, this));
                }
                catch (RejectedExecutionException e) {
                    this.openSockets.remove(socket);
                    log.error("HttpServerHandler execution rejected. Might be due to a proxies.xml hot deployment in progress or a low value for <transport maxThreadPoolSize=\"...\">.");
                    socket.close();
                }
            }
            catch (SocketException e) {
                String message = e.getMessage();
                if (message != null && (message.endsWith("socket closed") || message.endsWith("Socket closed"))) {
                    log.debug("socket closed.");
                    break;
                }
                log.error("", (Throwable)e);
            }
            catch (NullPointerException e) {
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public void closePort() throws IOException {
        this.closed = true;
        if (!this.serverSocket.isClosed()) {
            this.serverSocket.close();
        }
    }

    public boolean closeConnections(boolean onlyIdle) throws IOException {
        if (!this.closed) {
            throw new IllegalStateException("please call closePort() fist.");
        }
        for (Socket s : (onlyIdle ? this.idleSockets : this.openSockets).keySet()) {
            if (s.isClosed()) continue;
            s.close();
        }
        return this.openSockets.isEmpty();
    }

    void setIdleStatus(Socket socket, boolean isIdle) throws IOException {
        if (isIdle) {
            if (this.closed) {
                socket.close();
                throw new SocketException();
            }
            this.idleSockets.put(socket, Boolean.TRUE);
        } else {
            this.idleSockets.remove(socket);
        }
    }

    void setOpenStatus(Socket socket, boolean isOpen) {
        if (isOpen) {
            throw new InvalidParameterException("isOpen");
        }
        this.openSockets.remove(socket);
    }

    public int getNumberOfOpenConnections() {
        return this.openSockets.size();
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public SSLProvider getSslProvider() {
        return this.sslProvider;
    }
}

