/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.util.HttpUtil;
import java.net.MalformedURLException;
import java.net.URL;

public class HostColonPort {
    public final boolean useSSL;
    public final String host;
    public final int port;

    public HostColonPort(boolean useSSL, String hostAndPort) {
        String[] strs = hostAndPort.split(":");
        this.useSSL = useSSL;
        this.host = strs[0];
        this.port = strs.length > 1 ? Integer.parseInt(strs[1]) : 80;
    }

    public HostColonPort(boolean useSSL, String host, int port) {
        this.useSSL = useSSL;
        this.host = host;
        this.port = port;
    }

    public HostColonPort(URL url) throws MalformedURLException {
        this.useSSL = url.getProtocol().endsWith("s");
        this.host = url.getHost();
        this.port = HttpUtil.getPort(url);
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

