/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.InterceptorFlowController;
import com.predic8.membrane.core.transport.Transport;
import com.predic8.membrane.core.transport.http.AbortException;
import com.predic8.membrane.core.transport.http.EOFWhileReadingFirstLineException;
import com.predic8.membrane.core.transport.http.NoMoreRequestsException;
import com.predic8.membrane.core.transport.http.NoResponseException;
import com.predic8.membrane.core.util.ContentTypeDetector;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.predic8.membrane.core.util.HttpUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpHandler {
    private static Logger log = LoggerFactory.getLogger((String)AbstractHttpHandler.class.getName());
    protected Exchange exchange;
    protected Request srcReq;
    private static final InterceptorFlowController flowController = new InterceptorFlowController();
    private final Transport transport;

    public AbstractHttpHandler(Transport transport) {
        this.transport = transport;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public abstract void shutdownInput() throws IOException;

    public abstract InetAddress getLocalAddress();

    public abstract int getLocalPort();

    protected void invokeHandlers() throws IOException, EndOfStreamException, AbortException, NoMoreRequestsException, EOFWhileReadingFirstLineException {
        try {
            flowController.invokeHandlers(this.exchange, this.transport.getInterceptors());
            if (this.exchange.getResponse() == null) {
                throw new AbortException("No response was generated by the interceptor chain.");
            }
        }
        catch (Exception e) {
            if (this.exchange.getResponse() == null) {
                this.exchange.setResponse(this.generateErrorResponse(e));
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof EndOfStreamException) {
                throw (EndOfStreamException)e;
            }
            if (e instanceof AbortException) {
                throw (AbortException)e;
            }
            if (e instanceof NoMoreRequestsException) {
                throw (NoMoreRequestsException)e;
            }
            if (e instanceof NoResponseException) {
                throw (NoResponseException)e;
            }
            if (e instanceof EOFWhileReadingFirstLineException) {
                throw (EOFWhileReadingFirstLineException)e;
            }
            log.warn("An exception occured while handling a request: ", (Throwable)e);
        }
    }

    private Response generateErrorResponse(Exception e) {
        String msg;
        boolean printStackTrace = this.transport.isPrintStackTrace();
        if (printStackTrace) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            msg = sw.toString();
        } else {
            msg = e.toString();
        }
        String comment = "Stack traces can be " + (printStackTrace ? "dis" : "en") + "abled by setting the " + "@printStackTrace attribute on <a href=\"http://membrane-soa.org/esb-doc/current/configuration/reference/transport.htm\">transport</a>. " + "More details might be found in the log.";
        Response error = null;
        Response.ResponseBuilder b = null;
        if (e instanceof URISyntaxException) {
            b = Response.badRequest();
        }
        if (b == null) {
            b = Response.internalServerError();
        }
        switch (ContentTypeDetector.detect(this.exchange.getRequest()).getEffectiveContentType()) {
            case XML: {
                error = b.header(HttpUtil.createHeaders("text/xml;charset=UTF-8", new String[0])).body(("<error><message>" + StringEscapeUtils.escapeXml((String)msg) + "</message><comment>" + StringEscapeUtils.escapeXml((String)comment) + "</comment></error>").getBytes(Constants.UTF_8_CHARSET)).build();
                break;
            }
            case JSON: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    JsonGenerator jg = new JsonFactory().createGenerator((OutputStream)baos);
                    jg.writeStartObject();
                    jg.writeFieldName("error");
                    jg.writeString(msg);
                    jg.writeFieldName("comment");
                    jg.writeString(comment);
                    jg.close();
                }
                catch (Exception f) {
                    log.error("Error generating JSON error response", (Throwable)f);
                }
                error = b.header(HttpUtil.createHeaders("application/json;charset=utf-8", new String[0])).body(baos.toByteArray()).build();
                break;
            }
            case SOAP: {
                error = b.header(HttpUtil.createHeaders("text/xml;charset=UTF-8", new String[0])).body(HttpUtil.getFaultSOAPBody("Internal Server Error", msg + " " + comment).getBytes(Constants.UTF_8_CHARSET)).build();
                break;
            }
            case UNKNOWN: {
                error = HttpUtil.setHTMLErrorResponse(b, msg, comment);
            }
        }
        return error;
    }

    public boolean isMatchLocalPort() {
        return true;
    }

    public String getContextPath(Exchange exc) {
        return "";
    }
}

