/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.rules;

import com.predic8.membrane.core.rules.ServiceProxyKey;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerProxyKey
extends ServiceProxyKey {
    private static Logger log = LoggerFactory.getLogger((String)SwaggerProxyKey.class.getName());
    private Swagger swagger;
    private boolean allowUI;

    public SwaggerProxyKey(int port) {
        super(port);
    }

    public SwaggerProxyKey(int port, String ip) {
        super(port, ip);
    }

    public SwaggerProxyKey(String host, String method, String path, int port, String ip) {
        super(host, method, path, port, ip);
    }

    public SwaggerProxyKey(String host, String method, String path, int port) {
        super(host, method, path, port);
    }

    @Override
    public boolean complexMatch(String hostHeader, String method, String uri, String version, int port, String localIP) {
        if (this.swagger == null) {
            log.error("Swagger specification is null!");
            return false;
        }
        if (uri.endsWith("swagger.json")) {
            return true;
        }
        if (this.allowUI && method.equalsIgnoreCase("GET") && this.isUI(uri)) {
            return true;
        }
        Map paths = this.swagger.getPaths();
        for (Map.Entry p : paths.entrySet()) {
            if (!this.pathTemplateMatch(uri, (String)p.getKey()) || !this.methodMatch(method, (Path)p.getValue())) continue;
            log.debug("Request is a Swagger call according to specification");
            return true;
        }
        return false;
    }

    private boolean pathTemplateMatch(String calledURI, String specName) {
        String IDENTIFIER = "[-_a-zA-Z0-9]+";
        specName = specName.replaceAll("\\{[-_a-zA-Z0-9]+\\}", "[-_a-zA-Z0-9]+");
        String spec = this.swagger.getBasePath() + specName;
        return Pattern.matches(spec, calledURI);
    }

    private boolean methodMatch(String method, Path path) {
        return method.equalsIgnoreCase("GET") && path.getGet() != null || method.equalsIgnoreCase("POST") && path.getPost() != null || method.equalsIgnoreCase("HEAD") && path.getHead() != null || method.equalsIgnoreCase("PUT") && path.getPut() != null || method.equalsIgnoreCase("DELETE") && path.getDelete() != null;
    }

    private boolean isUI(String path) {
        return Arrays.asList("/", "/favicon.ico", "/swagger-ui.js", "/css/typography.css", "/css/reset.css", "/css/screen.css", "/css/print.css", "/lib/jquery.slideto.min.js", "/lib/jquery-1.8.0.min.js", "/lib/jquery.wiggle.min.js", "/lib/jquery.ba-bbq.min.js", "/lib/underscore-min.js", "/lib/handlebars-2.0.0.js", "/lib/backbone-min.js", "/lib/highlight.7.3.pack.js", "/lib/marked.js", "/lib/swagger-oauth.js", "/images/favicon-16x16.png", "/images/logo_small.png", "/fonts/droid-sans-v6-latin-700.woff2").contains(path);
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public void setSwagger(Swagger swag) {
        this.swagger = swag;
    }

    public boolean isAllowUI() {
        return this.allowUI;
    }

    public void setAllowUI(boolean allowUI) {
        this.allowUI = allowUI;
    }
}

