/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.rules;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.interceptor.swagger.SwaggerRewriterInterceptor;
import com.predic8.membrane.core.rules.AbstractProxy;
import com.predic8.membrane.core.rules.ServiceProxy;
import com.predic8.membrane.core.rules.SwaggerProxyKey;
import com.predic8.membrane.core.transport.http.HttpClient;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

@MCElement(name="swaggerProxy")
public class SwaggerProxy
extends ServiceProxy {
    private static Logger log = LoggerFactory.getLogger((String)SwaggerProxy.class.getName());
    private String swaggerUrl;
    private boolean allowUI = true;
    private Swagger swagger;

    public SwaggerProxy() {
        this.key = new SwaggerProxyKey(80);
    }

    public SwaggerProxy(SwaggerProxyKey ruleKey, String targetHost, int targetPort) {
        this.key = ruleKey;
        this.setTargetHost(targetHost);
        this.setTargetPort(targetPort);
    }

    @Override
    protected AbstractProxy getNewInstance() {
        return new SwaggerProxy();
    }

    @Override
    public void init() throws Exception {
        super.init();
        HttpClient hc = new HttpClient(this.router.getHttpClientConfig());
        Exchange ex = hc.call(new Request.Builder().get(this.swaggerUrl).buildExchange());
        if (ex.getResponse().getStatusCode() != 200) {
            log.error("Couldn't fetch Swagger URL!");
            throw new Exception("Couldn't fetch Swagger URL!");
        }
        this.swagger = new SwaggerParser().parse(ex.getResponse().getBodyAsStringDecoded());
        ((SwaggerProxyKey)this.key).setSwagger(this.swagger);
        ((SwaggerProxyKey)this.key).setAllowUI(this.allowUI);
        SwaggerRewriterInterceptor sri = new SwaggerRewriterInterceptor(this.swagger, this.swaggerUrl);
        this.interceptors.add(0, sri);
    }

    public String getUrl() {
        return this.swaggerUrl;
    }

    @Required
    @MCAttribute
    public void setUrl(String swaggerUrl) {
        this.swaggerUrl = swaggerUrl;
    }

    public boolean isAllowUI() {
        return this.allowUI;
    }

    @MCAttribute
    public void setAllowUI(boolean allowUI) {
        this.allowUI = allowUI;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }
}

