/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.jmx;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.rules.ServiceProxy;
import java.io.IOException;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class JmxServiceProxy {
    private final ServiceProxy rule;
    private final Router router;

    public JmxServiceProxy(ServiceProxy rule, Router router) {
        this.rule = rule;
        this.router = router;
    }

    @ManagedOperation
    public void toggleActive() throws IOException {
        if (this.isActive()) {
            this.router.getRuleManager().removeRule(this.rule);
        } else {
            this.router.getRuleManager().addProxyAndOpenPortIfNew(this.rule);
        }
        this.router.getRuleManager().ruleChanged(this.rule);
    }

    @ManagedAttribute
    public boolean isActive() {
        return this.router.getRuleManager().exists(this.rule.getKey());
    }

    @ManagedAttribute
    public int getProcessedExchanges() {
        return this.rule.getCount();
    }
}

