/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xmlcontentfilter;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.xmlcontentfilter.XMLContentFilter;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

@MCElement(name="xmlContentFilter")
public class XMLContentFilterInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(XMLContentFilterInterceptor.class);
    private String xPath;
    private XMLContentFilter xmlContentFilter;

    public XMLContentFilterInterceptor() {
        this.setFlow(Interceptor.Flow.Set.REQUEST_RESPONSE);
    }

    public String getXPath() {
        return this.xPath;
    }

    @Required
    @MCAttribute
    public void setXPath(String xPath) {
        this.xPath = xPath;
        try {
            this.xmlContentFilter = new XMLContentFilter(xPath);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        return this.handleMessage(exc, exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        return this.handleMessage(exc, exc.getResponse());
    }

    private Outcome handleMessage(Exchange exc, Message message) {
        try {
            this.xmlContentFilter.removeMatchingElements(message);
            return Outcome.CONTINUE;
        }
        catch (Exception e) {
            LOG.error("xmlContentFilter error", (Throwable)e);
            exc.setResponse(Response.internalServerError("xmlContentFilter error. See log for details.").build());
            return Outcome.ABORT;
        }
    }
}

