/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.soap;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import java.io.IOException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

@MCElement(name="soapOperationExtractor")
public class SoapOperationExtractor
extends AbstractInterceptor {
    public static final String SOAP_OPERATION = "XSLT_SOAP_OPERATION";
    public static final String SOAP_OPERATION_NS = "XSLT_SOAP_OPERATION_NS";
    private static final XOPReconstitutor xopr = new XOPReconstitutor();
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public SoapOperationExtractor() {
        this.name = "SOAP Operation Extractor";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription();
    }

    @Override
    public String getShortDescription() {
        return "Saves SOAP operation name and namespace into exchange properties.";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (exc.getRequest().isBodyEmpty() && !exc.getRequest().isXML()) {
            return Outcome.CONTINUE;
        }
        XMLStreamReader reader = this.getReader(exc);
        if (this.isNotSoap(reader)) {
            return Outcome.CONTINUE;
        }
        this.moveToSoapBody(reader);
        this.extractAndSaveNameAndNS(exc, reader);
        return Outcome.CONTINUE;
    }

    private void moveToTag(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            reader.next();
            if (!reader.isStartElement()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLStreamReader getReader(Exchange exc) throws XMLStreamException, FactoryConfigurationError, IOException {
        XMLInputFactory xMLInputFactory = xmlInputFactory;
        synchronized (xMLInputFactory) {
            return xmlInputFactory.createXMLStreamReader(xopr.reconstituteIfNecessary(exc.getRequest()));
        }
    }

    private boolean isNotSoap(XMLStreamReader reader) throws XMLStreamException {
        this.moveToTag(reader);
        return !"Envelope".equals(reader.getName().getLocalPart()) || !"http://schemas.xmlsoap.org/soap/envelope/".equals(reader.getNamespaceURI());
    }

    private void extractAndSaveNameAndNS(Exchange exc, XMLStreamReader reader) throws XMLStreamException {
        this.moveToTag(reader);
        exc.setProperty(SOAP_OPERATION, reader.getName().getLocalPart());
        exc.setProperty(SOAP_OPERATION_NS, reader.getNamespaceURI());
    }

    private void moveToSoapBody(XMLStreamReader reader) throws XMLStreamException {
        while (this.hasNextAndIsNotBody(reader)) {
            this.moveToTag(reader);
        }
    }

    private boolean hasNextAndIsNotBody(XMLStreamReader reader) throws XMLStreamException {
        return reader.hasNext() && (!reader.isStartElement() || !"Body".equals(reader.getName().getLocalPart()) || !"http://schemas.xmlsoap.org/soap/envelope/".equals(reader.getNamespaceURI()));
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }
}

