/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.ratelimit;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.ratelimit.LazyRateLimit;
import com.predic8.membrane.core.interceptor.ratelimit.RateLimitStrategy;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormat;

@MCElement(name="rateLimiter")
public class RateLimitInterceptor
extends AbstractInterceptor {
    public RateLimitStrategy rateLimitStrategy;

    public RateLimitInterceptor() {
        this(Duration.standardHours((long)1L), 1000);
    }

    public RateLimitInterceptor(Duration requestLimitDuration, int requestLimit) {
        this.rateLimitStrategy = new LazyRateLimit(requestLimitDuration, requestLimit);
        this.name = "RateLimiter";
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        String addr = exc.getRemoteAddrIp();
        if (this.rateLimitStrategy.isRequestLimitReached(addr)) {
            this.setResponseToServiceUnavailable(exc);
            return Outcome.RETURN;
        }
        return Outcome.CONTINUE;
    }

    public void setResponseToServiceUnavailable(Exchange exc) throws UnsupportedEncodingException {
        Header hd = new Header();
        DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZoneUTC().withLocale(Locale.US);
        hd.add("Date", dateFormatter.print((ReadableInstant)DateTime.now()));
        hd.add("X-LimitDuration", PeriodFormat.getDefault().print((ReadablePeriod)this.rateLimitStrategy.requestLimitDuration.toPeriod()));
        hd.add("X-LimitRequests", Integer.toString(this.rateLimitStrategy.requestLimit));
        String ip = exc.getRemoteAddrIp();
        DateTime availableAgainDateTime = this.rateLimitStrategy.getServiceAvailableAgainTime(ip);
        hd.add("X-LimitReset", Long.toString(availableAgainDateTime.getMillis()));
        StringBuilder bodyString = new StringBuilder();
        DateTimeFormatter dtFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss aa");
        bodyString.append(ip).append(" exceeded the rate limit of ").append(this.rateLimitStrategy.requestLimit).append(" requests per ").append(PeriodFormat.getDefault().print((ReadablePeriod)this.rateLimitStrategy.requestLimitDuration.toPeriod())).append(". The next request can be made at ").append(dtFormatter.print((ReadableInstant)availableAgainDateTime));
        Response resp = Response.ResponseBuilder.newInstance().status(429, "Too Many Requests.").contentType("text/plain;charset=UTF-8").header(hd).body(bodyString.toString()).build();
        exc.setResponse(resp);
    }

    public int getRequestLimit() {
        return this.rateLimitStrategy.requestLimit;
    }

    @MCAttribute
    public void setRequestLimit(int rl) {
        this.rateLimitStrategy.setRequestLimit(rl);
    }

    public String getRequestLimitDuration() {
        return this.rateLimitStrategy.requestLimitDuration.toString();
    }

    @MCAttribute
    public void setRequestLimitDuration(String rld) {
        this.setRequestLimitDuration(Duration.parse((String)rld));
    }

    public void setRequestLimitDuration(Duration rld) {
        this.rateLimitStrategy.setRequestLimitDuration(rld);
    }

    @Override
    public String getShortDescription() {
        return "Limits incoming requests. It limits to " + this.rateLimitStrategy.getRequestLimit() + " requests every " + PeriodFormat.getDefault().print((ReadablePeriod)this.rateLimitStrategy.getRequestLimitDuration().toPeriod()) + ".";
    }
}

