/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.ratelimit;

import com.predic8.membrane.core.interceptor.ratelimit.RateLimitStrategy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class LazyRateLimit
extends RateLimitStrategy {
    private DateTime nextCleanup = new DateTime();
    public ConcurrentHashMap<String, AtomicInteger> requestCounterFromIP = new ConcurrentHashMap();

    public LazyRateLimit(Duration requestLimitDuration, int requestLimit) {
        this.requestLimitDuration = requestLimitDuration;
        this.requestLimit = requestLimit;
        this.incrementNextCleanupTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRequestLimitReached(String ip) {
        DateTime dateTime = this.nextCleanup;
        synchronized (dateTime) {
            if (DateTime.now().isAfter((ReadableInstant)this.nextCleanup)) {
                for (AtomicInteger info : this.requestCounterFromIP.values()) {
                    info.set(0);
                }
                this.incrementNextCleanupTime();
            }
        }
        this.addRequestEntry(ip);
        return this.requestCounterFromIP.get(ip).get() > this.requestLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequestEntry(String addr) {
        ConcurrentHashMap<String, AtomicInteger> concurrentHashMap = this.requestCounterFromIP;
        synchronized (concurrentHashMap) {
            if (!this.requestCounterFromIP.containsKey(addr)) {
                this.requestCounterFromIP.put(addr, new AtomicInteger());
            }
        }
        this.requestCounterFromIP.get(addr).incrementAndGet();
    }

    private void incrementNextCleanupTime() {
        this.nextCleanup = DateTime.now().plus((ReadableDuration)this.requestLimitDuration);
    }

    @Override
    public DateTime getServiceAvailableAgainTime(String ip) {
        return this.nextCleanup;
    }

    @Override
    public void updateAfterConfigChange() {
        for (AtomicInteger info : this.requestCounterFromIP.values()) {
            info.set(0);
        }
        this.incrementNextCleanupTime();
    }
}

