/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.request.ParameterizedRequest;
import com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest.AuthorizationCodeFlow;
import com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest.CredentialsFlow;
import com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest.ErrorFlow;
import com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest.PasswordFlow;
import com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest.RefreshTokenFlow;
import com.predic8.membrane.core.util.URLParamUtil;
import java.util.Map;

public class TokenFlowDecider {
    private static final String AUTHORIZATION_CODE = "authorization_code";
    private static final String PASSWORD = "password";
    private static final String CLIENT_CREDENTIALS = "client_credentials";
    private static final String REFRESH_TOKEN = "refresh_token";
    Map<String, String> params;
    ParameterizedRequest flow;

    public TokenFlowDecider(OAuth2AuthorizationServerInterceptor authServer, Exchange exc) throws Exception {
        this.params = URLParamUtil.getParams(authServer.getRouter().getUriFactory(), exc);
        this.flow = new ErrorFlow(authServer, exc);
        if (this.getGrantType() == null) {
            return;
        }
        if (this.getGrantType().equals(AUTHORIZATION_CODE)) {
            this.flow = new AuthorizationCodeFlow(authServer, exc);
            authServer.getStatistics().codeFlow();
            return;
        }
        if (this.getGrantType().equals(PASSWORD)) {
            this.flow = new PasswordFlow(authServer, exc);
            authServer.getStatistics().passwordFlow();
            return;
        }
        if (this.getGrantType().equals(CLIENT_CREDENTIALS)) {
            this.flow = new CredentialsFlow(authServer, exc);
            authServer.getStatistics().clientCredentialsFlow();
            return;
        }
        if (this.getGrantType().equals(REFRESH_TOKEN)) {
            this.flow = new RefreshTokenFlow(authServer, exc);
            authServer.getStatistics().refreshTokenFlow();
        }
    }

    private String getGrantType() {
        return this.params.get("grant_type");
    }

    public ParameterizedRequest getFlow() {
        return this.flow;
    }
}

