/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.request.NoResponse;
import com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest.TokenRequest;
import java.io.IOException;
import java.util.Map;

public class PasswordFlow
extends TokenRequest {
    public PasswordFlow(OAuth2AuthorizationServerInterceptor authServer, Exchange exc) throws Exception {
        super(authServer, exc);
    }

    @Override
    protected Response checkForMissingParameters() throws Exception {
        if (this.getGrantType() == null || this.getUsername() == null || this.getPassword() == null || this.getClientId() == null || this.getClientSecret() == null) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "invalid_request");
        }
        return new NoResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response processWithParameters() throws Exception {
        SessionManager.Session session;
        if (!this.verifyClientThroughParams()) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "unauthorized_client");
        }
        Map<String, String> userParams = this.verifyUserThroughParams();
        if (userParams == null) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "access_denied");
        }
        this.scope = this.getScope();
        this.idToken = null;
        this.token = this.createTokenForVerifiedUserAndClient();
        this.refreshToken = this.authServer.getRefreshTokenGenerator().getToken(this.getUsername(), this.getClientId(), this.getClientSecret());
        this.exc.setResponse(this.getEarlyResponse());
        SessionManager.Session session2 = session = this.createSessionForAuthorizedUserWithParams();
        synchronized (session2) {
            session.getUserAttributes().put("access_token", this.token);
            session.getUserAttributes().putAll(userParams);
        }
        this.authServer.getSessionFinder().addSessionForToken(this.token, session);
        return new NoResponse();
    }

    @Override
    protected Response getResponse() throws Exception {
        return this.exc.getResponse();
    }

    private Response getEarlyResponse() throws IOException {
        return Response.ok().body(this.getTokenJSONResponse()).contentType("application/json;charset=utf-8").dontCache().build();
    }
}

