/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.ClaimRenamer;
import com.predic8.membrane.core.interceptor.oauth2.Client;
import com.predic8.membrane.core.interceptor.oauth2.ClientList;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.parameter.ClaimsParameter;
import com.predic8.membrane.core.interceptor.oauth2.request.NoResponse;
import com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest.TokenRequest;
import com.predic8.membrane.core.interceptor.oauth2.tokengenerators.JwtGenerator;
import java.util.ArrayList;
import org.jose4j.lang.JoseException;

public class AuthorizationCodeFlow
extends TokenRequest {
    public AuthorizationCodeFlow(OAuth2AuthorizationServerInterceptor authServer, Exchange exc) throws Exception {
        super(authServer, exc);
    }

    @Override
    protected Response checkForMissingParameters() throws Exception {
        if (this.getCode() == null || this.getClientId() == null || this.getClientSecret() == null || this.getRedirectUri() == null) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "invalid_request");
        }
        return new NoResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response processWithParameters() throws Exception {
        Client client;
        String username;
        if (!this.authServer.getSessionFinder().hasSessionForCode(this.getCode())) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "invalid_request");
        }
        SessionManager.Session session = this.authServer.getSessionFinder().getSessionForCode(this.getCode());
        this.authServer.getSessionFinder().removeSessionForCode(this.getCode());
        SessionManager.Session session2 = session;
        synchronized (session2) {
            username = session.getUserName();
            session.getUserAttributes().putAll(this.params);
        }
        try {
            ClientList clientList = this.authServer.getClientList();
            synchronized (clientList) {
                client = this.authServer.getClientList().getClient(this.getClientId());
            }
        }
        catch (Exception e) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "invalid_client");
        }
        if (!this.getClientSecret().equals(client.getClientSecret())) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "unauthorized_client");
        }
        if (!OAuth2Util.isAbsoluteUri(this.getRedirectUri()) || !this.getRedirectUri().equals(client.getCallbackUrl())) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "invalid_request");
        }
        this.scope = this.getScope(session);
        this.token = this.authServer.getTokenGenerator().getToken(username, client.getClientId(), client.getClientSecret());
        this.authServer.getSessionFinder().addSessionForToken(this.token, session);
        this.idToken = null;
        this.refreshToken = this.authServer.getRefreshTokenGenerator().getToken(username, client.getClientId(), client.getClientSecret());
        if (OAuth2Util.isOpenIdScope(this.scope)) {
            this.idToken = this.createSignedIdToken(session, username, client);
        }
        return new NoResponse();
    }

    private JwtGenerator.Claim[] getValidIdTokenClaims(SessionManager.Session session) {
        ClaimsParameter cp = new ClaimsParameter(this.authServer.getClaimList().getSupportedClaims(), session.getUserAttributes().get("claims"));
        ArrayList<JwtGenerator.Claim> claims = new ArrayList<JwtGenerator.Claim>();
        if (cp.hasClaims()) {
            for (String claim : cp.getIdTokenClaims()) {
                claims.add(new JwtGenerator.Claim(claim, session.getUserAttributes().get(ClaimRenamer.convert(claim))));
            }
        }
        return claims.toArray(new JwtGenerator.Claim[0]);
    }

    private String createSignedIdToken(SessionManager.Session session, String username, Client client) throws JoseException {
        return this.getSignedIdToken(username, client, this.getValidIdTokenClaims(session));
    }

    private String getSignedIdToken(String username, Client client, JwtGenerator.Claim ... claims) throws JoseException {
        return this.authServer.getJwtGenerator().getSignedIdToken(this.authServer.getIssuer(), username, client.getClientId(), 600, claims);
    }

    @Override
    protected Response getResponse() throws Exception {
        return Response.ok().body(this.getTokenJSONResponse()).contentType("application/json;charset=utf-8").dontCache().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getScope(SessionManager.Session session) {
        SessionManager.Session session2 = session;
        synchronized (session2) {
            return session.getUserAttributes().get("scope");
        }
    }
}

