/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest.TokenFlowDecider;

public class TokenEndpointProcessor
extends EndpointProcessor {
    public TokenEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        return exc.getRequestURI().startsWith("/oauth2/token");
    }

    @Override
    public Outcome process(Exchange exc) throws Exception {
        exc.setResponse(new TokenFlowDecider(this.authServer, exc).getFlow().validateRequest());
        if (exc.getResponse().getStatusCode() == 200) {
            this.authServer.getStatistics().accessTokenCreated();
        }
        return Outcome.RETURN;
    }
}

