/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.LoginDialog;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import com.predic8.membrane.core.util.URI;

public class LoginDialogEndpointProcessor
extends EndpointProcessor {
    private final LoginDialog loginDialog;

    public LoginDialogEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
        this.loginDialog = new LoginDialog(authServer.getUserDataProvider(), null, authServer.getSessionManager(), authServer.getAccountBlocker(), authServer.getLocation(), authServer.getPath(), authServer.isExposeUserCredentialsToSession(), authServer.getMessage());
        try {
            this.loginDialog.init(authServer.getRouter());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        URI uri = this.uriFactory.createWithoutException(exc.getRequest().getUri());
        return uri.getPath().startsWith(this.authServer.getPath()) && this.authServer.getSessionManager().getSession(exc) != null;
    }

    @Override
    public Outcome process(Exchange exc) throws Exception {
        this.loginDialog.handleLoginRequest(exc);
        return Outcome.RETURN;
    }
}

