/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.beautifier.JSONBeautifier;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;

public class CertsEndpointProcessor
extends EndpointProcessor {
    private JSONBeautifier jsonBeautifier = new JSONBeautifier();

    public CertsEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        return exc.getRequestURI().startsWith("/oauth2/certs");
    }

    @Override
    public Outcome process(Exchange exc) throws Exception {
        exc.setResponse(Response.ok().contentType("application/json;charset=utf-8").body(this.jsonBeautifier.beautify(this.authServer.getJwtGenerator().getJwk())).build());
        return Outcome.RETURN;
    }
}

