/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.parameter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.interceptor.oauth2.ReusableJsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class ClaimsParameter {
    public static final String USERINFO = "userinfo";
    public static final String ID_TOKEN = "id_token";
    private final HashSet<String> supportedClaims;
    private Map<String, Object> cleanedJson;

    public ClaimsParameter(HashSet<String> supportedClaims, String claimsParameter) {
        this.supportedClaims = supportedClaims;
        if (claimsParameter != null && !claimsParameter.isEmpty()) {
            this.parseClaimsParameter(claimsParameter);
        }
    }

    public static String writeCompleteJson(String userinfoClaims, String idTokenClaims) throws IOException {
        String[] userinfo = null;
        if (userinfoClaims != null && !userinfoClaims.isEmpty()) {
            userinfo = userinfoClaims.split(" ");
        }
        String[] idToken = null;
        if (idTokenClaims != null && !idTokenClaims.isEmpty()) {
            idToken = idTokenClaims.split(" ");
        }
        return ClaimsParameter.writeCompleteJson(userinfo, idToken);
    }

    public static String writeCompleteJson(String[] userinfoClaims, String[] idTokenClaims) throws IOException {
        return ClaimsParameter.writeCompleteJson(new ReusableJsonGenerator(), userinfoClaims, idTokenClaims);
    }

    public static String writeCompleteJson(ReusableJsonGenerator jsonGen, String[] userinfoClaims, String[] idTokenClaims) throws IOException {
        if (userinfoClaims == null && idTokenClaims == null) {
            return "";
        }
        JsonGenerator gen = jsonGen.resetAndGet();
        gen.writeStartObject();
        if (userinfoClaims != null) {
            ClaimsParameter.writeSingleClaimsObject(gen, USERINFO, userinfoClaims);
        }
        if (idTokenClaims != null) {
            ClaimsParameter.writeSingleClaimsObject(gen, ID_TOKEN, idTokenClaims);
        }
        gen.writeEndObject();
        return jsonGen.getJson();
    }

    static void writeSingleClaimsObject(JsonGenerator gen, String objectName, String ... claims) throws IOException {
        gen.writeObjectFieldStart(objectName);
        for (String claim : claims) {
            gen.writeObjectField(claim, null);
        }
        gen.writeEndObject();
    }

    private void parseClaimsParameter(String claimsParameter) {
        try {
            this.cleanedJson = this.getCleanedJson((Map)new ObjectMapper().readValue(claimsParameter, Map.class));
        }
        catch (IOException e) {
            return;
        }
    }

    private Map<String, Object> getCleanedJson(Map<String, Object> json) {
        this.cleanJsonObjectFromInvalidClaims(json, USERINFO);
        this.cleanJsonObjectFromInvalidClaims(json, ID_TOKEN);
        if (json.isEmpty()) {
            json = null;
        }
        return json;
    }

    private void cleanJsonObjectFromInvalidClaims(Map<String, Object> json, String name) {
        if (json.containsKey(name)) {
            this.cleanFromInvalidClaims((Map)json.get(name));
            if (((Map)json.get(name)).isEmpty()) {
                json.remove(name);
            }
        }
    }

    private void cleanFromInvalidClaims(Map<String, Object> json) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String claim : json.keySet()) {
            if (this.supportedClaims.contains(claim)) continue;
            toRemove.add(claim);
        }
        for (String claim : toRemove) {
            json.remove(claim);
        }
    }

    public boolean hasClaims() {
        return this.cleanedJson != null;
    }

    public String toJson() throws JsonProcessingException {
        return new ObjectMapper().writeValueAsString(this.cleanedJson);
    }

    private Map<String, Object> getObject(String objectName) {
        return (Map)this.cleanedJson.get(objectName);
    }

    private HashSet<String> getClaimsFromJsonObject(String objectName) {
        HashSet<String> claims = new HashSet<String>();
        for (String claimName : this.getObject(objectName).keySet()) {
            claims.add(claimName);
        }
        return claims;
    }

    public HashSet<String> getUserinfoClaims() {
        return this.getClaimsFromJsonObject(USERINFO);
    }

    public HashSet<String> getIdTokenClaims() {
        return this.getClaimsFromJsonObject(ID_TOKEN);
    }
}

