/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.flows;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.flows.OAuth2Flow;
import com.predic8.membrane.core.util.URLUtil;
import java.math.BigInteger;
import java.security.SecureRandom;

public class CodeFlow
extends OAuth2Flow {
    public CodeFlow(OAuth2AuthorizationServerInterceptor authServer, Exchange exc, SessionManager.Session s) {
        super(authServer, exc, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outcome getResponse() throws Exception {
        String code = CodeFlow.generateAuthorizationCode();
        SessionManager.Session session = this.session;
        synchronized (session) {
            this.session.getUserAttributes().put("code", code);
        }
        this.authServer.getSessionFinder().addSessionForCode(code, this.session);
        return this.respondWithAuthorizationCodeAndRedirect(this.exc, code, this.session);
    }

    protected static String generateAuthorizationCode() {
        return new BigInteger(130, new SecureRandom()).toString(32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Outcome respondWithAuthorizationCodeAndRedirect(Exchange exc, String code, SessionManager.Session s) throws Exception {
        String redirectUrl;
        String state = null;
        String rawQuery = URLUtil.getPathQuery(this.authServer.getRouter().getUriFactory(), exc.getRequestURI());
        if (rawQuery.startsWith("/")) {
            rawQuery = rawQuery.substring(1);
        }
        if (rawQuery.startsWith("?")) {
            rawQuery = rawQuery.substring(1);
        }
        if (!rawQuery.isEmpty()) {
            state = rawQuery;
        }
        SessionManager.Session session = s;
        synchronized (session) {
            if (state == null) {
                state = s.getUserAttributes().get("state");
            }
            redirectUrl = s.getUserAttributes().get("redirect_uri");
        }
        exc.setResponse(Response.redirect(redirectUrl + "?code=" + code + this.stateQuery(state), false).dontCache().body("").build());
        return Outcome.RETURN;
    }
}

