/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.authorizationservice;

import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.InterceptorFlowController;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2.Client;
import com.predic8.membrane.core.interceptor.oauth2.ReusableJsonGenerator;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import com.predic8.membrane.core.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@MCElement(name="registration")
public class DynamicRegistration {
    ReusableJsonGenerator jsonGenerator = new ReusableJsonGenerator();
    private List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private SSLParser sslParser;
    private SSLContext sslContext;
    private InterceptorFlowController flowController = new InterceptorFlowController();
    private HttpClient client = new HttpClient();

    public void init(Router router) throws Exception {
        if (this.sslParser != null) {
            this.sslContext = new StaticSSLContext(this.sslParser, router.getResolverMap(), router.getBaseLocation());
        }
        for (Interceptor i : this.interceptors) {
            i.init(router);
        }
    }

    public InputStream retrieveOpenIDConfiguration(String uri) throws Exception {
        return this.doRequest(new Request.Builder().get(uri).buildExchange()).getBodyAsStream();
    }

    public Client registerWithCallbackAt(String callbackUri, String registrationEndpoint) throws Exception {
        Exchange exc = new Request.Builder().post(registrationEndpoint).header("Content-Type", "application/json;charset=utf-8").body(this.getRegistrationBody(callbackUri)).buildExchange();
        Response response = this.doRequest(exc);
        HashMap<String, String> json = Util.parseSimpleJSONResponse(response);
        if (!json.containsKey("client_id") || !json.containsKey("client_secret")) {
            throw new RuntimeException("Registration endpoint didn't return clientId/clientSecret");
        }
        return new Client(json.get("client_id"), json.get("client_secret"), "");
    }

    private Response doRequest(Exchange exc) throws Exception {
        if (this.sslContext != null) {
            exc.setProperty("SSL_CONTEXT", this.sslContext);
        }
        if (this.flowController.invokeRequestHandlers(exc, this.interceptors) != Outcome.CONTINUE) {
            throw new RuntimeException("Registration interceptorchain had a problem");
        }
        Response response = this.client.call(exc).getResponse();
        if (response.getStatusCode() < 200 || response.getStatusCode() > 201) {
            throw new RuntimeException("Registration endpoint didn't return successful: " + response.getStatusMessage());
        }
        return response;
    }

    private String getRegistrationBody(String callbackUri) throws IOException {
        JsonGenerator jsonGen = this.jsonGenerator.resetAndGet();
        jsonGen.writeStartObject();
        jsonGen.writeArrayFieldStart("redirect_uris");
        jsonGen.writeString(callbackUri);
        jsonGen.writeEndArray();
        jsonGen.writeEndObject();
        return this.jsonGenerator.getJson();
    }

    public SSLParser getSslParser() {
        return this.sslParser;
    }

    @MCChildElement(order=10, allowForeign=true)
    public void setSslParser(SSLParser sslParser) {
        this.sslParser = sslParser;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @MCChildElement(order=20)
    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

