/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.authorizationservice;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthorizationService {
    protected Logger log;
    private HttpClient httpClient;
    protected Router router;
    protected HttpClientConfiguration httpClientConfiguration;
    protected String clientId;
    protected String clientSecret;
    protected String scope;
    private SSLParser sslParser;
    private SSLContext sslContext;
    protected boolean supportsDynamicRegistration = false;

    public boolean supportsDynamicRegistration() {
        return this.supportsDynamicRegistration;
    }

    public void init(Router router) throws Exception {
        this.log = LoggerFactory.getLogger((String)this.getClass().getName());
        this.setHttpClient(this.getHttpClientConfiguration() == null ? router.getResolverMap().getHTTPSchemaResolver().getHttpClient() : new HttpClient(this.getHttpClientConfiguration()));
        if (this.sslParser != null) {
            this.sslContext = new StaticSSLContext(this.sslParser, router.getResolverMap(), router.getBaseLocation());
        }
        this.router = router;
        this.init();
        if (!this.supportsDynamicRegistration()) {
            this.checkForClientIdAndSecret();
        }
    }

    public abstract void init() throws Exception;

    public abstract String getIssuer();

    public abstract String getJwksEndpoint() throws Exception;

    public abstract String getLoginURL(String var1, String var2, String var3);

    public abstract String getUserInfoEndpoint();

    public abstract String getSubject();

    public abstract String getTokenEndpoint();

    public abstract String getRevocationEndpoint();

    protected void doDynamicRegistration(Exchange exc, String publicURL) throws Exception {
    }

    public void dynamicRegistration(Exchange exc, String publicURL) throws Exception {
        if (this.supportsDynamicRegistration()) {
            this.doDynamicRegistration(exc, publicURL);
        }
    }

    protected void checkForClientIdAndSecret() {
        if (this.clientId == null || this.clientSecret == null) {
            throw new RuntimeException(this.getClass().getSimpleName() + " cannot work without specified clientId and clientSecret");
        }
    }

    public HttpClientConfiguration getHttpClientConfiguration() {
        return this.httpClientConfiguration;
    }

    @MCAttribute
    public void setHttpClientConfiguration(HttpClientConfiguration httpClientConfiguration) {
        this.httpClientConfiguration = httpClientConfiguration;
    }

    public String getClientId() {
        return this.clientId;
    }

    @MCAttribute
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    @MCAttribute
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getScope() {
        return this.scope;
    }

    @MCAttribute
    public void setScope(String scope) {
        this.scope = scope;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Response doRequest(Exchange e) throws Exception {
        if (this.sslContext != null) {
            e.setProperty("SSL_CONTEXT", this.sslContext);
        }
        return this.getHttpClient().call(e).getResponse();
    }

    public SSLParser getSslParser() {
        return this.sslParser;
    }

    @MCChildElement(order=20, allowForeign=true)
    public void setSslParser(SSLParser sslParser) {
        this.sslParser = sslParser;
    }
}

