/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.resolver.ResolverMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;

public class ConsentPageFile {
    public static final String SCOPE_DESCRIPTIONS = "scope_descriptions";
    public static final String CLAIM_DESCRIPTIONS = "claim_descriptions";
    public static final String PRODUCT_NAME = "product_name";
    public static final String LOGO_URL = "logo_url";
    public static final String SCOPES = "scopes";
    public static final String CLAIMS = "claims";
    private ResolverMap resolver;
    private String productName;
    private String logoUrl;
    ConcurrentHashMap<String, String> scopesToDescriptions = new ConcurrentHashMap();
    ConcurrentHashMap<String, String> claimsToDescriptions = new ConcurrentHashMap();
    private Map<String, Object> json;

    public void init(Router router, String url) throws IOException {
        this.resolver = router.getResolverMap();
        if (url == null) {
            this.createDefaults();
            return;
        }
        this.parseFile(this.getFromUrl(ResolverMap.combine(router.getBaseLocation(), url)));
    }

    private void parseFile(String consentPageFile) throws IOException {
        this.parseJson(consentPageFile);
        this.parseProductAndLogo();
        this.parseScopes();
        this.parseClaims();
    }

    private void parseJson(String consentPageFile) throws IOException {
        this.json = (Map)new ObjectMapper().readValue(consentPageFile, Map.class);
    }

    private void parseProductAndLogo() {
        this.setProductName((String)this.json.get(PRODUCT_NAME));
        this.setLogoUrl((String)this.json.get(LOGO_URL));
    }

    private void parseClaims() {
        Map claims = (Map)this.json.get(CLAIMS);
        for (String claim : claims.keySet()) {
            this.claimsToDescriptions.put(claim, (String)claims.get(claim));
        }
    }

    private void parseScopes() {
        Map scopes = (Map)this.json.get(SCOPES);
        for (String scope : scopes.keySet()) {
            this.scopesToDescriptions.put(scope, (String)scopes.get(scope));
        }
    }

    private String getFromUrl(String url) throws IOException {
        return IOUtils.toString((InputStream)this.resolver.resolve(url));
    }

    private void createDefaults() {
    }

    public String convertScope(String scope) {
        if (!this.scopesToDescriptions.containsKey(scope)) {
            return scope;
        }
        return this.scopesToDescriptions.get(scope);
    }

    public String convertClaim(String claim) {
        if (!this.claimsToDescriptions.containsKey(claim)) {
            return claim;
        }
        return this.claimsToDescriptions.get(claim);
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }
}

