/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.javascript;

import com.google.common.base.Function;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.lang.javascript.JavascriptLanguageSupport;
import com.predic8.membrane.core.util.ClassFinder;
import com.predic8.membrane.core.util.TextUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

@MCElement(name="javascript", mixed=true)
public class JavascriptInterceptor
extends AbstractInterceptor {
    private String src = "";
    private Function<Map<String, Object>, Object> script;
    private JavascriptLanguageSupport jls;
    private HashMap<String, Object> implicitClasses;

    public JavascriptInterceptor() {
        this.name = "Javascript";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        return this.runScript(exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        return this.runScript(exc, Interceptor.Flow.RESPONSE);
    }

    @Override
    public void handleAbort(Exchange exc) {
        try {
            this.runScript(exc, Interceptor.Flow.ABORT);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() throws IOException, ClassNotFoundException {
        if (this.router == null) {
            return;
        }
        if ("".equals(this.src)) {
            return;
        }
        this.jls = new JavascriptLanguageSupport();
        this.implicitClasses = this.getJavascriptTypesForHttpClasses();
        this.script = this.jls.compileScript(this.router, this.src);
    }

    private Outcome runScript(Exchange exc, Interceptor.Flow flow) throws InterruptedException, IOException, ClassNotFoundException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("exc", exc);
        parameters.put("flow", (Object)flow);
        parameters.put("spring", this.router.getBeanFactory());
        this.addOutcomeObjects(parameters);
        parameters.putAll(this.implicitClasses);
        Object res = this.script.apply(parameters);
        if (res instanceof Outcome) {
            return (Outcome)((Object)res);
        }
        if (res instanceof Response) {
            exc.setResponse((Response)res);
            return Outcome.RETURN;
        }
        if (res instanceof Request) {
            exc.setRequest((Request)res);
        }
        return Outcome.CONTINUE;
    }

    private HashMap<String, Object> getJavascriptTypesForHttpClasses() throws IOException, ClassNotFoundException {
        return this.getJavascriptTypesForClasses(this.getHttpPackageClasses());
    }

    private HashMap<String, Object> getJavascriptTypesForClasses(HashMap<String, Object> classes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Object clazz : classes.values()) {
            Class clazzz = (Class)clazz;
            String scriptSrc = clazzz.getSimpleName() + ".static;";
            Object jsType = this.jls.compileScript(this.router, scriptSrc).apply(classes);
            result.put(clazzz.getSimpleName(), jsType);
        }
        return result;
    }

    private void addOutcomeObjects(HashMap<String, Object> parameters) {
        parameters.put("Outcome", Outcome.class);
        parameters.put("RETURN", (Object)Outcome.RETURN);
        parameters.put("CONTINUE", (Object)Outcome.CONTINUE);
        parameters.put("ABORT", (Object)Outcome.ABORT);
    }

    private HashMap<String, Object> getHttpPackageClasses() throws IOException, ClassNotFoundException {
        String httpPackage = "com.predic8.membrane.core.http";
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Class<?>> classes = ClassFinder.find(this.router.getBeanFactory().getClassLoader(), httpPackage);
        for (Class<?> c : classes) {
            if (!c.getPackage().getName().equals(httpPackage) || c.getSimpleName().isEmpty()) continue;
            result.put(c.getSimpleName(), c);
        }
        return result;
    }

    public String getSrc() {
        return this.src;
    }

    @MCTextContent
    public void setSrc(String src) {
        this.src = src;
    }

    @Override
    public String getShortDescription() {
        return "Executes a Javascript script.";
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(TextUtil.removeFinalChar(this.getShortDescription()));
        sb.append(":<br/><pre style=\"overflow-x:auto\">");
        sb.append(StringEscapeUtils.escapeHtml((String)TextUtil.removeCommonLeadingIndentation(this.src)));
        sb.append("</pre>");
        return sb.toString();
    }
}

