/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.groovy;

import com.google.common.base.Function;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.lang.groovy.GroovyLanguageSupport;
import com.predic8.membrane.core.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

@MCElement(name="groovy", mixed=true)
public class GroovyInterceptor
extends AbstractInterceptor {
    private String src = "";
    private Function<Map<String, Object>, Object> script;

    public GroovyInterceptor() {
        this.name = "Groovy";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        return this.runScript(exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        return this.runScript(exc, Interceptor.Flow.RESPONSE);
    }

    @Override
    public void handleAbort(Exchange exc) {
        try {
            this.runScript(exc, Interceptor.Flow.ABORT);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void init() {
        if (this.router == null) {
            return;
        }
        if ("".equals(this.src)) {
            return;
        }
        this.script = new GroovyLanguageSupport().compileScript(this.router, this.src);
    }

    private Outcome runScript(Exchange exc, Interceptor.Flow flow) throws InterruptedException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("exc", exc);
        parameters.put("flow", (Object)flow);
        parameters.put("spring", this.router.getBeanFactory());
        Object res = this.script.apply(parameters);
        if (res instanceof Outcome) {
            return (Outcome)((Object)res);
        }
        if (res instanceof Response) {
            exc.setResponse((Response)res);
            return Outcome.RETURN;
        }
        if (res instanceof Request) {
            exc.setRequest((Request)res);
        }
        return Outcome.CONTINUE;
    }

    public String getSrc() {
        return this.src;
    }

    @MCTextContent
    public void setSrc(String src) {
        this.src = src;
    }

    @Override
    public String getShortDescription() {
        return "Executes a groovy script.";
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(TextUtil.removeFinalChar(this.getShortDescription()));
        sb.append(":<br/><pre style=\"overflow-x:auto\">");
        sb.append(StringEscapeUtils.escapeHtml((String)TextUtil.removeCommonLeadingIndentation(this.src)));
        sb.append("</pre>");
        return sb.toString();
    }
}

