/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.flow;

import com.google.common.base.Function;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.InterceptorFlowController;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.flow.AbstractFlowInterceptor;
import com.predic8.membrane.core.lang.LanguageSupport;
import com.predic8.membrane.core.lang.groovy.GroovyLanguageSupport;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

@MCElement(name="if")
public class ConditionalInterceptor
extends AbstractFlowInterceptor {
    private static final Logger log = LoggerFactory.getLogger(InterceptorFlowController.class);
    private String test;
    private LanguageType language = LanguageType.GROOVY;
    private final InterceptorFlowController interceptorFlowController = new InterceptorFlowController();
    private Function<Map<String, Object>, Boolean> condition;

    public ConditionalInterceptor() {
        this.name = "Conditional Interceptor";
    }

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
        GroovyLanguageSupport ls = new GroovyLanguageSupport();
        this.condition = ((LanguageSupport)ls).compileExpression(router, this.test);
    }

    private boolean testCondition(Exchange exc) {
        HashMap<String, Exchange> parameters = new HashMap<String, Exchange>();
        parameters.put("exc", exc);
        return (Boolean)this.condition.apply(parameters);
    }

    @Override
    public Outcome handleRequest(Exchange exchange) throws Exception {
        boolean logDebug = log.isDebugEnabled();
        boolean handleRequest = this.testCondition(exchange);
        if (logDebug) {
            log.debug("ConditionalInterceptor: expression evaluated to " + handleRequest);
        }
        if (handleRequest) {
            return this.interceptorFlowController.invokeRequestHandlers(exchange, this.getInterceptors());
        }
        return Outcome.CONTINUE;
    }

    public LanguageType getLanguage() {
        return this.language;
    }

    @MCAttribute
    public void setLanguage(LanguageType language) {
        this.language = language;
    }

    public String getTest() {
        return this.test;
    }

    @Required
    @MCAttribute
    public void setTest(String test) {
        this.test = test;
    }

    @Override
    public String getShortDescription() {
        String ret = "if (" + this.test + ") {";
        for (Interceptor i : this.getInterceptors()) {
            ret = ret + "<br/>&nbsp;&nbsp;&nbsp;&nbsp;" + i.getDisplayName();
        }
        ret = ret + "<br/>}";
        return ret;
    }

    public static enum LanguageType {
        GROOVY;

    }
}

