/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.FixedStreamReader;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.balancer.AbstractSessionIdExtractor;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

@MCElement(name="xmlSessionIdExtractor")
public class XMLElementSessionIdExtractor
extends AbstractSessionIdExtractor {
    private static Logger log = LoggerFactory.getLogger((String)XMLElementSessionIdExtractor.class.getName());
    private String localName;
    private String namespace;
    private XMLInputFactory fac = XMLInputFactory.newInstance();

    @Override
    public String getSessionId(Message msg) throws Exception {
        if (!msg.isXML()) {
            log.debug("Didn't search a XML element in none XML message.");
            return null;
        }
        log.debug("searching for sessionid");
        this.fac.setProperty("javax.xml.stream.isNamespaceAware", this.namespace != null);
        FixedStreamReader reader = new FixedStreamReader(this.fac.createXMLStreamReader(msg.getBodyAsStreamDecoded(), msg.getCharset()));
        while (reader.hasNext()) {
            reader.next();
            if (!this.isSessionIdElement(reader)) continue;
            log.debug("sessionid element found");
            return reader.getElementText();
        }
        log.debug("no sessionid element found");
        return null;
    }

    private boolean isSessionIdElement(XMLStreamReader reader) {
        return reader.isStartElement() && this.localName.equals(reader.getLocalName()) && (this.namespace == null || this.namespace.equals(reader.getNamespaceURI()));
    }

    public String getLocalName() {
        return this.localName;
    }

    @Required
    @MCAttribute
    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Required
    @MCAttribute
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public void write(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("xmlSessionIdExtractor");
        out.writeAttribute("localName", this.localName);
        out.writeAttribute("namespace", this.namespace);
        out.writeEndElement();
    }

    @Override
    protected void parseAttributes(XMLStreamReader token) throws XMLStreamException {
        this.localName = token.getAttributeValue("", "localName");
        this.namespace = token.getAttributeValue("", "namespace");
    }

    @Override
    protected String getElementName() {
        return "sessionIdExtractor";
    }
}

