/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.balancer.Cluster;
import com.predic8.membrane.core.interceptor.balancer.LoadBalancingInterceptor;
import com.predic8.membrane.core.interceptor.balancer.Node;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="nodeOnlineChecker")
public class NodeOnlineChecker {
    private static Logger log = LoggerFactory.getLogger((String)NodeOnlineChecker.class.getName());
    LoadBalancingInterceptor lbi;
    ConcurrentHashMap<String, BadNode> badNodesForDestinations = new ConcurrentHashMap();
    HashSet<BadNode> offlineNodes = new HashSet();
    private int retryTimeInSeconds = -1;
    private int nodeCounterLimit5XX = 10;
    private int pingTimeoutInSeconds = 1;
    private DateTime lastCheck = DateTime.now();

    public int getPingTimeoutInSeconds() {
        return this.pingTimeoutInSeconds;
    }

    public void setPingTimeoutInSeconds(int pingTimeoutInSeconds) {
        this.pingTimeoutInSeconds = pingTimeoutInSeconds;
    }

    public void handle(Exchange exc) {
        int i;
        if (exc.getNodeExceptions() != null) {
            for (i = 0; i < exc.getDestinations().size(); ++i) {
                if (exc.getNodeExceptions()[i] == null) continue;
                this.handleNodeException(exc, i);
            }
        }
        if (exc.getNodeStatusCodes() != null) {
            for (i = 0; i < exc.getDestinations().size(); ++i) {
                int status;
                if (exc.getNodeStatusCodes()[i] == 0 || (status = exc.getNodeStatusCodes()[i]) < 400 || status >= 600) continue;
                this.handleNodeBadStatusCode(exc, i);
            }
        }
    }

    public void handleNodeBadStatusCode(Exchange exc, int destination) {
        int statuscode = exc.getNodeStatusCodes()[destination];
        String destinationString = this.getDestinationAsString(exc, destination);
        if (statuscode < 500) {
            this.badNodesForDestinations.remove(destinationString);
        } else if (statuscode >= 500) {
            int currentFails;
            if (!this.badNodesForDestinations.containsKey(destinationString)) {
                this.badNodesForDestinations.put(destinationString, new BadNode(this.getNodeFromExchange(exc, destination)));
            }
            if ((currentFails = this.badNodesForDestinations.get(destinationString).getFailsOn5XX().incrementAndGet()) > this.nodeCounterLimit5XX) {
                this.setNodeDown(exc, destination);
            }
        }
    }

    public void handleNodeException(Exchange exc, int destination) {
        this.badNodesForDestinations.put(this.getDestinationAsString(exc, destination), new BadNode(this.getNodeFromExchange(exc, destination)));
        this.setNodeDown(exc, destination);
    }

    public Node getNodeFromExchange(Exchange exc, int destination) {
        URL destUrl = this.getUrlObjectFromDestination(exc, destination);
        return new Node(destUrl.getProtocol() + "://" + destUrl.getHost(), destUrl.getPort());
    }

    public String getDestinationAsString(Exchange exc, int destination) {
        return exc.getDestinations().get(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeDown(Exchange exc, int destination) {
        String destinationAsString = this.getDestinationAsString(exc, destination);
        BadNode bad = this.badNodesForDestinations.get(destinationAsString);
        HashSet<BadNode> hashSet = this.offlineNodes;
        synchronized (hashSet) {
            for (Cluster cl : this.lbi.getClusterManager().getClusters()) {
                Node node = bad.getNode();
                if (!cl.getNodes().contains(node)) continue;
                cl.nodeDown(node);
                bad.getNodeClusters().add(cl);
            }
            this.offlineNodes.add(bad);
        }
        log.info("Node down: " + destinationAsString);
    }

    private URL getUrlObjectFromDestination(Exchange exc, int destination) {
        String url = this.getDestinationAsString(exc, destination);
        URL u = null;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return u;
    }

    public void putNodesBackUp() {
        if (this.retryTimeInSeconds < 0) {
            return;
        }
        if (this.retryTimeInSeconds > 0 && DateTime.now().isBefore((ReadableInstant)this.lastCheck.plusSeconds(this.retryTimeInSeconds))) {
            return;
        }
        List<BadNode> onlineNodes = this.pingOfflineNodes();
        for (BadNode node : onlineNodes) {
            this.putNodeUp(node);
        }
    }

    private void putNodeUp(BadNode node) {
        for (Cluster cl : node.getNodeClusters()) {
            cl.nodeUp(node.getNode());
        }
        this.offlineNodes.remove(node);
        log.info("Node up: " + node.getNode().getHost() + ":" + node.getNode().getPort());
    }

    private List<BadNode> pingOfflineNodes() {
        ArrayList<BadNode> onlineNodes = new ArrayList<BadNode>();
        for (BadNode node : this.offlineNodes) {
            URL url = null;
            try {
                url = new URL(node.getNode().getHost());
            }
            catch (MalformedURLException ignored) {
                continue;
            }
            try {
                HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                urlConn.setConnectTimeout(this.pingTimeoutInSeconds * 1000);
                urlConn.connect();
                if (urlConn.getResponseCode() != 200) continue;
                onlineNodes.add(node);
            }
            catch (IOException ignored) {}
        }
        return onlineNodes;
    }

    public LoadBalancingInterceptor getLbi() {
        return this.lbi;
    }

    public void setLbi(LoadBalancingInterceptor lbi) {
        this.lbi = lbi;
    }

    public int getRetryTimeInSeconds() {
        return this.retryTimeInSeconds;
    }

    @MCAttribute
    public void setRetryTimeInSeconds(int retryTimeInSeconds) {
        this.retryTimeInSeconds = retryTimeInSeconds;
    }

    public int getNodeCounterLimit5XX() {
        return this.nodeCounterLimit5XX;
    }

    @MCAttribute
    public void setNodeCounterLimit5XX(int nodeCounterLimit5XX) {
        this.nodeCounterLimit5XX = nodeCounterLimit5XX;
    }

    private class BadNode {
        private Node node;
        private AtomicInteger failsOn5XX = new AtomicInteger(0);
        private HashSet<Cluster> nodeClusters = new HashSet();

        public BadNode(Node node) {
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public AtomicInteger getFailsOn5XX() {
            return this.failsOn5XX;
        }

        public void setFailsOn5XX(AtomicInteger failsOn5XX) {
            this.failsOn5XX = failsOn5XX;
        }

        public HashSet<Cluster> getNodeClusters() {
            return this.nodeClusters;
        }

        public void setNodeClusters(HashSet<Cluster> nodeClusters) {
            this.nodeClusters = nodeClusters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BadNode badNode = (BadNode)o;
            return this.node.equals(badNode.node);
        }

        public int hashCode() {
            return this.node.hashCode();
        }
    }
}

