/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.interceptor.balancer.Node;
import com.predic8.membrane.core.interceptor.balancer.Session;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="cluster", topLevel=false)
public class Cluster {
    private static Logger log = LoggerFactory.getLogger((String)Cluster.class.getName());
    public static final String DEFAULT_NAME = "Default";
    private String name = "Default";
    private List<Node> nodes = Collections.synchronizedList(new LinkedList());
    private Map<String, Session> sessions = new Hashtable<String, Session>();

    public Cluster() {
    }

    public Cluster(String name) {
        this.name = name;
    }

    public void nodeUp(Node n) {
        log.debug("node: " + n + " up");
        this.getNodeCreateIfNeeded(n).setLastUpTime(System.currentTimeMillis());
        this.getNodeCreateIfNeeded(n).setStatus(Node.Status.UP);
    }

    public void nodeDown(Node n) {
        log.debug("node: " + n + " down");
        this.getNodeCreateIfNeeded(n).setStatus(Node.Status.DOWN);
    }

    public void nodeTakeOut(Node n) {
        log.debug("node: " + n + " takeout");
        this.getNodeCreateIfNeeded(n).setStatus(Node.Status.TAKEOUT);
    }

    public boolean removeNode(Node node) {
        return this.nodes.remove(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> getAvailableNodes(long timeout) {
        LinkedList<Node> l = new LinkedList<Node>();
        List<Node> list = this.nodes;
        synchronized (list) {
            for (Node n : this.getAllNodes(timeout)) {
                if (!n.isUp()) continue;
                l.add(n);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> getAllNodes(long timeout) {
        if (timeout <= 0L) {
            return this.nodes;
        }
        List<Node> list = this.nodes;
        synchronized (list) {
            for (Node n : this.nodes) {
                if (System.currentTimeMillis() - n.getLastUpTime() <= timeout) continue;
                n.setStatus(Node.Status.DOWN);
            }
        }
        return this.nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNode(Node ep) {
        List<Node> list = this.nodes;
        synchronized (list) {
            return this.nodes.get(this.nodes.indexOf(ep));
        }
    }

    private Node getNodeCreateIfNeeded(Node ep) {
        if (this.nodes.contains(ep)) {
            return this.getNode(ep);
        }
        log.debug("creating endpoint: " + ep);
        this.nodes.add(new Node(ep.getHost(), ep.getPort()));
        return this.getNode(ep);
    }

    public List<Node> getNodes() {
        return new ArrayList<Node>(this.nodes){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean add(Node e) {
                Cluster.this.nodes.add(e);
                return super.add(e);
            }
        };
    }

    @MCChildElement
    public void setNodes(List<Node> nodes) {
        this.nodes.clear();
        this.nodes.addAll(nodes);
    }

    public String getName() {
        return this.name;
    }

    @MCAttribute
    public void setName(String name) {
        this.name = name;
    }

    public boolean containsSession(String sessionId) {
        return this.sessions.containsKey(sessionId) && this.sessions.get(sessionId).getNode().isUp();
    }

    public void addSession(String sessionId, Node n) {
        this.sessions.put(sessionId, new Session(sessionId, n));
    }

    public Map<String, Session> getSessions() {
        return this.sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Session> getSessionsByNode(Node node) {
        LinkedList<Session> l = new LinkedList<Session>();
        Map<String, Session> map = this.sessions;
        synchronized (map) {
            for (Session s : this.sessions.values()) {
                if (!s.getNode().equals(node)) continue;
                l.add(s);
            }
        }
        return l;
    }
}

