/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer;

import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.interceptor.balancer.BalancerUtil;
import com.predic8.membrane.core.interceptor.balancer.Cluster;
import com.predic8.membrane.core.interceptor.balancer.Node;
import com.predic8.membrane.core.interceptor.balancer.Session;
import com.predic8.membrane.core.interceptor.balancer.SessionCleanupThread;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="clusters", topLevel=false)
public class Balancer
extends AbstractXmlElement {
    public static final String DEFAULT_NAME = "Default";
    private static Logger log = LoggerFactory.getLogger((String)Balancer.class.getName());
    private final Map<String, Cluster> clusters = new Hashtable<String, Cluster>();
    private String name = "Default";
    private long timeout = 0L;
    private SessionCleanupThread sct;

    public Balancer() {
        this.addCluster(BalancerUtil.getSingleClusterNameOrDefault(this));
        this.sct = new SessionCleanupThread(this.clusters);
        this.sct.start();
    }

    protected void finalize() throws Throwable {
        if (this.sct != null) {
            this.sct.interrupt();
            this.sct = null;
        }
        super.finalize();
    }

    public long getSessionTimeout() {
        return this.sct == null ? 0L : this.sct.getSessionTimeout();
    }

    public void setSessionTimeout(long sessionTimeout) {
        if (sessionTimeout == 0L) {
            if (this.sct != null) {
                this.sct.interrupt();
                this.sct = null;
            }
        } else {
            if (this.sct == null) {
                this.sct = new SessionCleanupThread(this.clusters);
                this.sct.start();
            }
            this.sct.setSessionTimeout(sessionTimeout);
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public List<Cluster> getClusters() {
        return new ArrayList<Cluster>(this.clusters.values()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean add(Cluster e) {
                Balancer.this.clusters.put(e.getName(), e);
                return super.add(e);
            }
        };
    }

    private Cluster getCluster(String name) {
        if (!this.clusters.containsKey(name)) {
            this.addCluster(name);
        }
        return this.clusters.get(name);
    }

    public boolean addCluster(String name) {
        if (this.clusters.containsKey(name)) {
            return false;
        }
        log.debug("adding cluster with name [" + name + "] to balancer [" + name + "]");
        this.clusters.put(name, new Cluster(name));
        return true;
    }

    @MCChildElement
    public void setClusters(List<Cluster> clusters) {
        this.clusters.clear();
        for (Cluster cluster : clusters) {
            this.clusters.put(cluster.getName(), cluster);
        }
    }

    public void up(String cName, String host, int port) {
        this.getCluster(cName).nodeUp(new Node(host, port));
    }

    public void down(String cName, String host, int port) {
        this.getCluster(cName).nodeDown(new Node(host, port));
    }

    public void takeout(String cName, String host, int port) {
        this.getCluster(cName).nodeTakeOut(new Node(host, port));
    }

    public List<Node> getAllNodesByCluster(String cName) {
        return this.getCluster(cName).getAllNodes(this.timeout);
    }

    public List<Node> getAvailableNodesByCluster(String cName) {
        return this.getCluster(cName).getAvailableNodes(this.timeout);
    }

    public void addSession2Cluster(String sessionId, String cName, Node n) {
        this.getCluster(cName).addSession(sessionId, n);
    }

    public void removeNode(String cluster, String host, int port) {
        this.getCluster(cluster).removeNode(new Node(host, port));
    }

    public Node getNode(String cluster, String host, int port) {
        return this.getCluster(cluster).getNode(new Node(host, port));
    }

    public Map<String, Session> getSessions(String cluster) {
        return this.getCluster(cluster).getSessions();
    }

    public List<Session> getSessionsByNode(String cName, Node node) {
        return this.getCluster(cName).getSessionsByNode(node);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

