/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.interceptor.authentication.session.SMSTokenProvider;
import com.predic8.membrane.core.transport.http.HttpClient;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

@MCElement(name="whateverMobileSMSTokenProvider", topLevel=false)
public class WhateverMobileSMSTokenProvider
extends SMSTokenProvider {
    private static Logger log = LoggerFactory.getLogger((String)WhateverMobileSMSTokenProvider.class.getName());
    private HttpClient hc;
    private String user;
    private String password;
    private String senderName;
    private boolean backupServiceAvailable;
    private static final String HOST = "http.secure.api.whatevermobile.com:7011";
    private static final String GATEWAY = "https://http.secure.api.whatevermobile.com:7011/sendsms";
    private static final String HOST2 = "http.secure.api.fra.whatevermobile.com:7011";
    private static final String GATEWAY2 = "https://http.secure.api.fra.whatevermobile.com:7011/sendsms";

    @Override
    public void init(Router router) {
        this.hc = router.getResolverMap().getHTTPSchemaResolver().getHttpClient();
    }

    @Override
    protected String normalizeNumber(String number) {
        return number.replaceAll("\\+", "00").replaceAll("[- ]|\\(.*\\)", "");
    }

    @Override
    protected void sendSMS(String text, String recipientNumber) {
        this.sendSmsToGateway(true, text, recipientNumber);
    }

    private void logSmsOK(boolean primary, String recipientNumber) {
        String tail = primary ? "Primary Gateway" : "Secondary Gateway";
        log.debug("Successfully sent SMS to " + recipientNumber + " via whateverMobile " + tail);
    }

    private void logSmsError(boolean primary, Exchange exc) {
        String head = primary ? "Primary Gateway" : "Both Primary and Secondary Gateway";
        log.error(head + " failed when sending SMS." + " REQUEST: " + exc.getRequest().toString() + (exc.getResponse() != null ? " RESPONSE: " + exc.getResponse().toString() : ""));
    }

    private void sendSmsToGateway(boolean primary, String text, String recipientNumber) {
        AbstractExchange exc = null;
        try {
            exc = new Request.Builder().post(primary ? GATEWAY : GATEWAY2).header("Host", primary ? HOST : HOST2).header("Content-Type", "application/x-www-form-urlencoded").body(this.generateRequestData(this.senderName, recipientNumber, text)).buildExchange();
        }
        catch (URISyntaxException e1) {
            this.logSmsError(primary, (Exchange)exc);
        }
        try {
            this.hc.call((Exchange)exc, false, true);
            if (exc.getResponse().getStatusCode() == 200) {
                this.logSmsOK(primary, recipientNumber);
            } else {
                this.logSmsError(primary, (Exchange)exc);
                if (primary && this.backupServiceAvailable) {
                    this.sendSmsToGateway(false, text, recipientNumber);
                }
            }
        }
        catch (Exception e) {
            this.logSmsError(primary, (Exchange)exc);
        }
    }

    private String generateRequestData(String from, String to, String body) {
        String request = "";
        try {
            request = "user=" + URLEncoder.encode(this.user, "ISO-8859-15");
            request = request + "&password=" + URLEncoder.encode(this.password, "ISO-8859-15");
            request = request + "&from=" + URLEncoder.encode(from, "ISO-8859-15");
            request = request + "&to=" + URLEncoder.encode(to, "ISO-8859-15");
            request = request + "&body=" + URLEncoder.encode(body, "ISO-8859-15");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Invalid encoding in generateRequestData.", (Throwable)e);
        }
        return request;
    }

    public String getGatewayUserName() {
        return this.user;
    }

    @Required
    @MCAttribute
    public void setGatewayUserName(String user) {
        this.user = user;
    }

    public String getGatewayPassword() {
        return this.password;
    }

    @Required
    @MCAttribute
    public void setGatewayPassword(String pw) {
        this.password = pw;
    }

    public String getSenderName() {
        return this.senderName;
    }

    @MCAttribute
    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public boolean isBackupServiceAvailable() {
        return this.backupServiceAvailable;
    }

    @MCAttribute
    public void setBackupServiceAvailable(boolean backup) {
        this.backupServiceAvailable = backup;
    }
}

