/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apimanagement.quota;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.apimanagement.ApiManagementConfiguration;
import com.predic8.membrane.core.interceptor.apimanagement.Key;
import com.predic8.membrane.core.interceptor.apimanagement.policy.Policy;
import com.predic8.membrane.core.interceptor.apimanagement.quota.ApiKeyByteCounter;
import com.predic8.membrane.core.interceptor.apimanagement.quota.PolicyQuota;
import com.predic8.membrane.core.interceptor.apimanagement.quota.QuotaReachedAnswer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="amQuota")
public class AMQuota {
    private static Logger log = LoggerFactory.getLogger(AMQuota.class);
    private ApiManagementConfiguration amc;
    public ConcurrentHashMap<String, ApiKeyByteCounter> keyByteCounter = new ConcurrentHashMap();
    public ConcurrentHashMap<String, PolicyQuota> policyQuotas = new ConcurrentHashMap();
    private Runnable observer = new Runnable(){

        @Override
        public void run() {
            log.info("Getting new config");
            AMQuota.this.fillPolicyQuotas();
            AMQuota.this.keyByteCounter = new ConcurrentHashMap();
        }
    };

    public ApiManagementConfiguration getAmc() {
        return this.amc;
    }

    public void setAmc(ApiManagementConfiguration amc) {
        if (this.amc != null) {
            this.amc.configChangeObservers.remove(this.observer);
        }
        this.amc = amc;
        this.fillPolicyQuotas();
        amc.configChangeObservers.add(this.observer);
    }

    private void fillPolicyQuotas() {
        this.policyQuotas.clear();
        for (Policy policy : this.amc.getPolicies().values()) {
            String name = policy.getName();
            long quotaSize = policy.getQuota().getSize();
            int interval = policy.getQuota().getInterval();
            HashSet<String> services = new HashSet<String>(policy.getServiceProxies());
            PolicyQuota pq = new PolicyQuota();
            pq.setName(name);
            pq.setSize(quotaSize);
            pq.setInterval(Duration.standardSeconds((long)interval));
            pq.incrementNextCleanup();
            pq.setServices(services);
            this.policyQuotas.put(name, pq);
        }
    }

    public Outcome handleRequest(Exchange exc) {
        return this.handle(exc, exc.getRequest());
    }

    public Outcome handleResponse(Exchange exc) {
        return this.handle(exc, exc.getResponse());
    }

    private Outcome handle(Exchange exc, Message msg) {
        Object apiKeyObj = exc.getProperty("API_KEY");
        if (apiKeyObj == null) {
            log.warn("No api key set in exchange");
            return Outcome.RETURN;
        }
        String apiKey = (String)apiKeyObj;
        String requestedService = exc.getRule().getName();
        QuotaReachedAnswer answer = this.isQuotaReached(msg, requestedService, apiKey);
        if (msg instanceof Request && answer.isQuotaReached()) {
            this.setResponseToServiceUnavailable(exc, answer.getPq());
            return Outcome.RETURN;
        }
        return Outcome.CONTINUE;
    }

    private void setResponseToServiceUnavailable(Exchange exc, PolicyQuota pq) {
        Header hd = new Header();
        DateTimeFormatter dtFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss aa");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JsonGenerator jgen = null;
        try {
            jgen = new JsonFactory().createGenerator((OutputStream)os);
            jgen.writeStartObject();
            jgen.writeObjectField("Statuscode", (Object)429);
            jgen.writeObjectField("Message", (Object)"Quota Exceeded");
            jgen.writeEndObject();
            jgen.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Response resp = Response.ResponseBuilder.newInstance().status(429, "Too Many Requests.").header(hd).contentType("application/json").body(os.toByteArray()).build();
        exc.setResponse(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuotaReachedAnswer isQuotaReached(Message msg, String requestedService, String apiKey) {
        this.doCleanup();
        long size = msg.getHeader().toString().getBytes().length + msg.getHeader().getContentLength();
        this.addRequestEntry(apiKey, size);
        ApiKeyByteCounter info = this.keyByteCounter.get(apiKey);
        boolean resultTemp = false;
        PolicyQuota pqTemp = null;
        ApiKeyByteCounter apiKeyByteCounter = info;
        synchronized (apiKeyByteCounter) {
            for (String policy : info.getPolicyByteCounters().keySet()) {
                PolicyQuota pq = this.policyQuotas.get(policy);
                if (!pq.getServices().contains(requestedService)) continue;
                if (info.getPolicyByteCounters().get(policy).get() > pq.getSize()) {
                    resultTemp = true;
                    pqTemp = pq;
                    continue;
                }
                resultTemp = false;
                break;
            }
        }
        if (resultTemp) {
            return QuotaReachedAnswer.createQuotaReached(pqTemp);
        }
        return QuotaReachedAnswer.createQuotaNotReached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequestEntry(String apiKey, long sizeOfBytes) {
        ConcurrentHashMap<String, ApiKeyByteCounter> concurrentHashMap = this.keyByteCounter;
        synchronized (concurrentHashMap) {
            if (!this.keyByteCounter.containsKey(apiKey)) {
                ApiKeyByteCounter value = new ApiKeyByteCounter();
                Key key = this.amc.getKeys().get(apiKey);
                for (Policy p : key.getPolicies()) {
                    value.getPolicyByteCounters().put(p.getName(), new AtomicLong());
                }
                this.keyByteCounter.put(apiKey, value);
            }
        }
        ApiKeyByteCounter keyInfo = this.keyByteCounter.get(apiKey);
        for (AtomicLong counter : keyInfo.getPolicyByteCounters().values()) {
            counter.addAndGet(sizeOfBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanup() {
        ConcurrentHashMap<String, PolicyQuota> concurrentHashMap = this.policyQuotas;
        synchronized (concurrentHashMap) {
            for (PolicyQuota pq : this.policyQuotas.values()) {
                if (!DateTime.now().isAfter((ReadableInstant)pq.getNextCleanup())) continue;
                for (ApiKeyByteCounter keyInfo : this.keyByteCounter.values()) {
                    if (!keyInfo.getPolicyByteCounters().keySet().contains(pq.getName())) continue;
                    keyInfo.getPolicyByteCounters().get(pq.getName()).set(0L);
                }
                pq.incrementNextCleanup();
            }
        }
    }
}

