/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apimanagement;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.administration.AdminConsoleInterceptor;
import com.predic8.membrane.core.interceptor.apimanagement.ApiKeyRetriever;
import com.predic8.membrane.core.interceptor.apimanagement.ApiManagementConfiguration;
import com.predic8.membrane.core.interceptor.apimanagement.AuthorizationResult;
import com.predic8.membrane.core.interceptor.apimanagement.HeaderKeyRetriever;
import com.predic8.membrane.core.interceptor.apimanagement.Key;
import com.predic8.membrane.core.interceptor.apimanagement.apiconfig.ApiConfig;
import com.predic8.membrane.core.interceptor.apimanagement.apiconfig.EtcdRegistryApiConfig;
import com.predic8.membrane.core.interceptor.apimanagement.apiconfig.SimpleApiConfig;
import com.predic8.membrane.core.interceptor.apimanagement.policy.Policy;
import com.predic8.membrane.core.interceptor.apimanagement.quota.AMQuota;
import com.predic8.membrane.core.interceptor.apimanagement.rateLimiter.AMRateLimiter;
import com.predic8.membrane.core.interceptor.apimanagement.statistics.AMStatisticsCollector;
import com.predic8.membrane.core.rules.AbstractServiceProxy;
import com.predic8.membrane.core.rules.Rule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="apiManagement")
public class ApiManagementInterceptor
extends AbstractInterceptor {
    public static final String APPLICATION_JSON = "application/json";
    private static Logger log = LoggerFactory.getLogger(ApiManagementInterceptor.class);
    private ApiConfig apiConfig;
    private AMRateLimiter amRateLimiter = null;
    private AMQuota amQuota = null;
    private AMStatisticsCollector amStatisticsCollector;
    private ApiManagementConfiguration apiManagementConfiguration = null;
    private String config = "api.yaml";
    private ApiKeyRetriever apiKeyRetriever = new HeaderKeyRetriever();

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
        Map apiConfigs = router.getBeanFactory().getBeansOfType(ApiConfig.class);
        String etcdRegistryApiConfigCorrected = this.getCorrectedName(EtcdRegistryApiConfig.class.getSimpleName());
        String simpleApiConfigCorrected = this.getCorrectedName(SimpleApiConfig.class.getSimpleName());
        if (apiConfigs.containsKey(etcdRegistryApiConfigCorrected)) {
            this.apiConfig = (ApiConfig)apiConfigs.get(etcdRegistryApiConfigCorrected);
        } else if (apiConfigs.containsKey(simpleApiConfigCorrected)) {
            this.apiConfig = (ApiConfig)apiConfigs.get(simpleApiConfigCorrected);
        }
        if (this.apiConfig != null) {
            log.info("used apiConfig: " + this.apiConfig.getClass().getSimpleName());
            this.apiManagementConfiguration = this.apiConfig.getConfiguration();
        } else {
            log.info("No ApiConfig set. Using default");
            this.apiManagementConfiguration = new ApiManagementConfiguration(router.getBaseLocation(), this.config);
        }
        this.addInterceptors();
    }

    private void addInterceptors() {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append("Api Management Interceptor");
        ArrayList<String> interceptors = new ArrayList<String>();
        nameBuilder.append(" { ");
        if (this.amRateLimiter != null) {
            this.amRateLimiter.setAmc(this.apiManagementConfiguration);
            interceptors.add("RateLimiter");
        }
        if (this.amQuota != null) {
            this.amQuota.setAmc(this.apiManagementConfiguration);
            interceptors.add("Quota");
        }
        interceptors.add("Statistics");
        if (interceptors.size() > 0) {
            nameBuilder.append((String)interceptors.get(0));
            for (int i = 1; i < interceptors.size(); ++i) {
                nameBuilder.append(", ").append((String)interceptors.get(i));
            }
        }
        nameBuilder.append(" }");
        this.name = nameBuilder.toString();
    }

    private String getCorrectedName(String etcdRegistryApiConfig) {
        return etcdRegistryApiConfig.substring(0, 1).toLowerCase() + etcdRegistryApiConfig.substring(1);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (this.getAmStatisticsCollector() != null) {
            return this.getAmStatisticsCollector().handleRequest(exc, this.handleRequest2(exc));
        }
        return this.handleRequest2(exc);
    }

    private Outcome handleRequest2(Exchange exc) throws Exception {
        String key = this.getAndRemoveKey(exc);
        if (key == null || !this.apiManagementConfiguration.getKeys().containsKey(key) || this.isAdminConsoleCall(exc)) {
            return this.processUnauthorizedRequest(exc);
        }
        exc.setProperty("API_KEY", key);
        AuthorizationResult auth = this.getAuthorization(exc, key);
        if (auth.isAuthorized()) {
            return this.processAuthorizedRequest(exc);
        }
        this.setResponsePolicyDenied(exc, auth);
        return Outcome.RETURN;
    }

    private boolean keyExists(String key) {
        return this.apiManagementConfiguration.getKeys().containsKey(key);
    }

    private Outcome processAuthorizedRequest(Exchange exc) throws Exception {
        if (this.getAmRateLimiter() != null && this.getAmRateLimiter().handleRequest(exc) == Outcome.RETURN) {
            return Outcome.RETURN;
        }
        if (this.getAmQuota() != null && this.getAmQuota().handleRequest(exc) == Outcome.RETURN) {
            return Outcome.RETURN;
        }
        return Outcome.CONTINUE;
    }

    private Outcome processUnauthorizedRequest(Exchange exc) throws Exception {
        String ip = exc.getRemoteAddrIp();
        exc.setProperty("API_KEY", ip);
        this.apiManagementConfiguration.addIpAsApiKeyIfNeeded(ip);
        if (this.isAdminConsoleCall(exc)) {
            return Outcome.CONTINUE;
        }
        if (this.hasUnauthorizedPolicy(exc)) {
            return this.processAuthorizedRequest(exc);
        }
        this.setResponseNoAuthKey(exc);
        return Outcome.RETURN;
    }

    private String getAndRemoveKey(Exchange exc) {
        String key = this.apiKeyRetriever.getKey(exc);
        this.apiKeyRetriever.removeKey(exc);
        return key;
    }

    private boolean isAdminConsoleCall(Exchange exc) {
        for (Rule r : this.router.getRuleManager().getRules()) {
            if (!(r instanceof AbstractServiceProxy)) continue;
            for (Interceptor i : r.getInterceptors()) {
                if (!(i instanceof AdminConsoleInterceptor)) continue;
                for (Interceptor interceptor : exc.getRule().getInterceptors()) {
                    if (interceptor != i) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        if (this.getAmStatisticsCollector() != null) {
            return this.getAmStatisticsCollector().handleResponse(exc, this.handleResponse2(exc));
        }
        return this.handleResponse2(exc);
    }

    private Outcome handleResponse2(Exchange exc) {
        if (!this.hasUnauthorizedPolicy(exc) && !this.isAdminConsoleCall(exc) && this.getAmQuota() != null) {
            this.getAmQuota().handleResponse(exc);
        }
        return Outcome.CONTINUE;
    }

    private boolean hasUnauthorizedPolicy(Exchange exc) {
        String requestedServiceProxy = exc.getRule().getName();
        for (Policy pol : this.apiManagementConfiguration.getPolicies().values()) {
            if (!pol.getServiceProxies().contains(requestedServiceProxy) || !pol.isUnauthenticated()) continue;
            return true;
        }
        return false;
    }

    public AuthorizationResult getAuthorization(Exchange exc, String apiKey) {
        if (!this.keyExists(apiKey)) {
            return AuthorizationResult.getAuthorizedFalse("API key not found");
        }
        if (this.keyIsExpired(apiKey)) {
            return AuthorizationResult.getAuthorizedFalse("API key expired");
        }
        for (Policy policy : this.getKey(apiKey).getPolicies()) {
            if (!policy.getServiceProxies().contains(exc.getRule().getName())) continue;
            return AuthorizationResult.getAuthorizedTrue();
        }
        return AuthorizationResult.getAuthorizedFalse("Service not available: " + exc.getRule().getName());
    }

    private boolean keyIsExpired(String apiKey) {
        if (this.getKey(apiKey).getExpiration() == null) {
            return false;
        }
        return this.getKey(apiKey).getExpiration().isBefore(Instant.now());
    }

    private Key getKey(String apiKey) {
        return this.apiManagementConfiguration.getKeys().get(apiKey);
    }

    private byte[] buildJsonErrorMessage(Response res) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            JsonGenerator jgen = new JsonFactory().createGenerator((OutputStream)os);
            jgen.writeStartObject();
            jgen.writeObjectField("Statuscode", (Object)res.getStatusCode());
            jgen.writeObjectField("Message", (Object)res.getStatusMessage());
            jgen.writeEndObject();
            jgen.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return os.toByteArray();
    }

    private void setResponsePolicyDenied(Exchange exc, AuthorizationResult auth) {
        this.setErrorResponse(exc, Response.badRequest(auth.getReason()));
    }

    private void setResponseNoAuthKey(Exchange exc) {
        this.setErrorResponse(exc, Response.unauthorized());
    }

    private void setErrorResponse(Exchange exc, Response.ResponseBuilder builder) {
        Response res = builder.contentType(APPLICATION_JSON).build();
        res.setBodyContent(this.buildJsonErrorMessage(res));
        exc.setResponse(res);
    }

    public AMRateLimiter getAmRateLimiter() {
        return this.amRateLimiter;
    }

    @MCChildElement(order=0)
    public void setAmRateLimiter(AMRateLimiter amRateLimiter) {
        this.amRateLimiter = amRateLimiter;
    }

    public AMQuota getAmQuota() {
        return this.amQuota;
    }

    @MCChildElement(order=1)
    public void setAmQuota(AMQuota amQuota) {
        this.amQuota = amQuota;
    }

    public String getConfig() {
        return this.config;
    }

    @MCAttribute
    public void setConfig(String config) {
        this.config = config;
    }

    public AMStatisticsCollector getAmStatisticsCollector() {
        return this.amStatisticsCollector;
    }

    @MCChildElement(order=2)
    public void setAmStatisticsCollector(AMStatisticsCollector amStatisticsCollector) {
        this.amStatisticsCollector = amStatisticsCollector;
    }
}

