/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.administration;

import com.googlecode.jatl.Html;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchangestore.LimitedMemoryExchangeStore;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.administration.AdminPageBuilder;
import com.predic8.membrane.core.interceptor.administration.Mapping;
import com.predic8.membrane.core.interceptor.administration.PropertyValueCollector;
import com.predic8.membrane.core.interceptor.administration.RuleUtil;
import com.predic8.membrane.core.interceptor.balancer.BalancerUtil;
import com.predic8.membrane.core.interceptor.balancer.Node;
import com.predic8.membrane.core.interceptor.rest.RESTInterceptor;
import com.predic8.membrane.core.rules.AbstractServiceProxy;
import com.predic8.membrane.core.rules.ProxyRule;
import com.predic8.membrane.core.rules.ProxyRuleKey;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.ServiceProxy;
import com.predic8.membrane.core.rules.ServiceProxyKey;
import com.predic8.membrane.core.transport.PortOccupiedException;
import com.predic8.membrane.core.util.DateUtil;
import com.predic8.membrane.core.util.HttpUtil;
import com.predic8.membrane.core.util.URLParamUtil;
import com.predic8.membrane.core.util.URLUtil;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicAdminPageInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)DynamicAdminPageInterceptor.class.getName());
    private boolean readOnly;

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        log.debug("request: " + exc.getOriginalRequestUri());
        exc.setTimeReqSent(System.currentTimeMillis());
        Outcome o = this.dispatchRequest(exc);
        exc.setReceived();
        exc.setTimeResReceived(System.currentTimeMillis());
        return o;
    }

    @Mapping(value="/admin/?(\\?.*)?")
    public Response handleHomeRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        return this.respond(this.getServiceProxyPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/proxy/?(\\?.*)?")
    public Response handleProxyRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        return this.respond(this.getProxyPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/service-proxy/show/?(\\?.*)?")
    public Response handleServiceProxyShowRequest(Map<String, String> params, final String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        final AbstractServiceProxy rule = (AbstractServiceProxy)RuleUtil.findRuleByIdentifier(this.router, params.get("name"));
        return this.respond(new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 0;
            }

            @Override
            protected String getTitle() {
                return super.getTitle() + " " + rule.toString() + " ServiceProxy";
            }

            @Override
            protected void createTabContent() throws Exception {
                ((Html)((Html)this.h1()).text(rule.toString() + " ServiceProxy")).end();
                ((Html)((Html)this.script()).raw("$(function() {\r\n\t\t\t\t\t$( \"#subtab\" ).tabs();\r\n\t\t\t\t});")).end();
                ((Html)this.div()).id("subtab");
                this.ul();
                ((Html)((Html)((Html)((Html)this.li()).a()).href("#tab1")).text("Visualization")).end(2);
                ((Html)((Html)((Html)((Html)this.li()).a()).href("#tab2")).text("Statistics")).end(2);
                this.end();
                ((Html)this.div()).id("tab1");
                this.createServiceProxyVisualization(rule, relativeRootPath);
                this.end();
                ((Html)this.div()).id("tab2");
                this.createStatusCodesTable(rule.getStatisticsByStatusCodes());
                this.br();
                this.createButton("View Messages", "calls", null, URLParamUtil.createQueryString("proxy", rule.toString()));
                this.end();
                this.end();
            }
        }.createPage());
    }

    @Mapping(value="/admin/proxy/show/?(\\?.*)?")
    public Response handlePruleShowRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        final ProxyRule rule = (ProxyRule)RuleUtil.findRuleByIdentifier(this.router, params.get("name"));
        return this.respond(new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 1;
            }

            @Override
            protected String getTitle() {
                return super.getTitle() + " " + rule.toString() + " Proxy";
            }

            @Override
            protected void createTabContent() throws Exception {
                ((Html)((Html)this.h1()).text(rule.toString() + " Proxy")).end();
                if (rule.getKey().getPort() != -1) {
                    this.table();
                    this.createTr("Listen Port", "" + rule.getKey().getPort());
                    this.end();
                }
                ((Html)((Html)this.h2()).text("Status Codes")).end();
                this.createStatusCodesTable(rule.getStatisticsByStatusCodes());
                ((Html)((Html)this.h2()).text("Interceptors")).end();
                this.createInterceptorTable(rule.getInterceptors());
            }
        }.createPage());
    }

    @Mapping(value="/admin/service-proxy/save/?(\\?.*)?")
    public Response handleServiceProxySaveRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        if (this.readOnly) {
            return this.createReadOnlyErrorResponse();
        }
        this.logAddFwdRuleParams(params);
        ServiceProxy r = new ServiceProxy(new ServiceProxyKey("*", params.get("method"), ".*", this.getPortParam(params), null), params.get("targetHost"), this.getTargetPortParam(params));
        r.setName(params.get("name"));
        try {
            this.router.getRuleManager().addProxyAndOpenPortIfNew(r);
        }
        catch (PortOccupiedException e) {
            return Response.internalServerError("The port could not be opened: Either it is occupied or Membrane does not have enough privileges to do so.").build();
        }
        return this.respond(this.getServiceProxyPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/proxy/save/?(\\?.*)?")
    public Response handleProxySaveRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        if (this.readOnly) {
            return this.createReadOnlyErrorResponse();
        }
        log.debug("adding proxy rule");
        log.debug("name: " + params.get("name"));
        log.debug("port: " + params.get("port"));
        ProxyRule r = new ProxyRule(new ProxyRuleKey(Integer.parseInt(params.get("port")), null));
        r.setName(params.get("name"));
        this.router.getRuleManager().addProxyAndOpenPortIfNew(r);
        return this.respond(this.getProxyPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/service-proxy/delete/?(\\?.*)?")
    public Response handleServiceProxyDeleteRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        if (this.readOnly) {
            return this.createReadOnlyErrorResponse();
        }
        Rule rule = RuleUtil.findRuleByIdentifier(this.router, params.get("name"));
        if (rule != null) {
            this.router.getRuleManager().removeRule(rule);
        }
        return this.respond(this.getServiceProxyPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/service-proxy/start/?(\\?.*)?")
    public Response handleServiceProxyStartRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        if (this.readOnly) {
            return this.createReadOnlyErrorResponse();
        }
        Rule rule = RuleUtil.findRuleByIdentifier(this.router, params.get("name"));
        Rule newRule = rule.clone();
        this.router.getRuleManager().replaceRule(rule, newRule);
        return this.respond(this.getServiceProxyPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/proxy/delete/?(\\?.*)?")
    public Response handleProxyDeleteRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        if (this.readOnly) {
            return this.createReadOnlyErrorResponse();
        }
        this.router.getRuleManager().removeRule(RuleUtil.findRuleByIdentifier(this.router, params.get("name")));
        return this.respond(this.getProxyPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/transport/?(\\?.*)?")
    public Response handleTransportRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return this.respond(new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 2;
            }

            @Override
            protected void createTabContent() throws Exception {
                ((Html)((Html)this.h2()).text("Transport")).end();
                ((Html)((Html)this.h3()).text("Transport Interceptors")).end();
                this.createInterceptorTable(DynamicAdminPageInterceptor.this.router.getTransport().getInterceptors());
            }
        }.createPage());
    }

    @Mapping(value="/admin/system/?(\\?.*)?")
    public Response handleSystemRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return this.respond(new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){
            static final int mb = 0x100000;
            final DecimalFormat formatter;
            {
                this.formatter = new DecimalFormat("#.00");
            }

            private String formatMemoryValue(float value) {
                float newValue = value / 1048576.0f;
                String unit = "MB";
                if (newValue > 1024.0f) {
                    unit = "GB";
                }
                return this.formatter.format(newValue) + " " + unit;
            }

            @Override
            protected int getSelectedTab() {
                return 3;
            }

            @Override
            protected void createTabContent() {
                ((Html)((Html)this.h2()).text("System")).end();
                ((Html)((Html)this.p()).text("Availabe system memory: " + this.formatMemoryValue(Runtime.getRuntime().totalMemory()))).end();
                ((Html)((Html)this.p()).text("Free system memory: " + this.formatMemoryValue(Runtime.getRuntime().freeMemory()))).end();
                ((Html)((Html)this.p()).text("Membrane version: " + Constants.VERSION)).end();
            }
        }.createPage());
    }

    @Mapping(value="/admin/balancers/?(\\?.*)?")
    public Response handleBalancersRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        return this.respond(this.getBalancersPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/clusters/?(\\?.*)?")
    public Response handleClustersRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        return this.respond(this.getClustersPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/clusters/show/?(\\?.*)?")
    public Response handleClustersShowRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        return this.respond(this.getClusterPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/clusters/save/?(\\?.*)?")
    public Response handleClustersSaveRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        if (this.readOnly) {
            return this.createReadOnlyErrorResponse();
        }
        log.debug("adding cluster");
        log.debug("balancer: " + DynamicAdminPageInterceptor.getBalancerParam(params));
        log.debug("name: " + params.get("name"));
        BalancerUtil.lookupBalancer(this.router, DynamicAdminPageInterceptor.getBalancerParam(params)).addCluster(params.get("name"));
        return this.respond(this.getClustersPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/node/show/?(\\?.*)?")
    public Response handleNodeShowRequest(final Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return this.respond(new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 4;
            }

            @Override
            protected void createTabContent() throws Exception {
                String balancer = DynamicAdminPageInterceptor.getBalancerParam(params);
                ((Html)((Html)this.h2()).text("Node " + (String)params.get("host") + ":" + (String)params.get("port") + " (" + "Cluster " + (String)params.get("cluster") + " of Balancer " + balancer + ")")).end();
                ((Html)((Html)this.h3()).text("Status Codes")).end();
                Node n = BalancerUtil.lookupBalancer(DynamicAdminPageInterceptor.this.router, balancer).getNode((String)params.get("cluster"), (String)params.get("host"), Integer.parseInt((String)params.get("port")));
                this.createStatusCodesTable(n.getStatisticsByStatusCodes());
                ((Html)((Html)this.p()).text("Total requests: " + n.getCounter())).end();
                ((Html)((Html)this.p()).text("Current threads: " + n.getThreads())).end();
                ((Html)((Html)this.p()).text("Requests without responses: " + n.getLost())).end();
                ((Html)this.span()).classAttr("mb-button");
                this.createLink("Reset Counter", "node", "reset", URLParamUtil.createQueryString("balancer", balancer, "cluster", (String)params.get("cluster"), "host", n.getHost(), "port", "" + n.getPort()));
                this.end();
                ((Html)this.span()).classAttr("mb-button");
                this.createLink("Show Sessions", "node", "sessions", URLParamUtil.createQueryString("balancer", balancer, "cluster", (String)params.get("cluster"), "host", n.getHost(), "port", "" + n.getPort()));
                this.end();
            }
        }.createPage());
    }

    @Mapping(value="/admin/node/sessions/?(\\?.*)?")
    public Response handleNodeSessionsRequest(final Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return this.respond(new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 4;
            }

            @Override
            protected void createTabContent() throws Exception {
                ((Html)((Html)this.h2()).text("Node " + (String)params.get("host") + ":" + (String)params.get("port"))).end();
                ((Html)((Html)this.h3()).text("Sessions")).end();
                this.createSessionsTable(BalancerUtil.lookupBalancer(DynamicAdminPageInterceptor.this.router, DynamicAdminPageInterceptor.getBalancerParam(params)).getSessionsByNode((String)params.get("cluster"), new Node((String)params.get("host"), Integer.parseInt((String)params.get("port")))));
            }
        }.createPage());
    }

    @Mapping(value="/admin/node/save/?(\\?.*)?")
    public Response handleNodeSaveRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        if (this.readOnly) {
            return this.createReadOnlyErrorResponse();
        }
        log.debug("adding node");
        log.debug("balancer: " + DynamicAdminPageInterceptor.getBalancerParam(params));
        log.debug("cluster: " + params.get("cluster"));
        log.debug("host: " + params.get("host"));
        log.debug("port: " + params.get("port"));
        BalancerUtil.lookupBalancer(this.router, DynamicAdminPageInterceptor.getBalancerParam(params)).up(params.get("cluster"), params.get("host"), Integer.parseInt(params.get("port")));
        return this.redirect("clusters", "show", URLParamUtil.createQueryString("balancer", DynamicAdminPageInterceptor.getBalancerParam(params), "cluster", params.get("cluster")), relativeRootPath);
    }

    @Mapping(value="/admin/node/up/?(\\?.*)?")
    public Response handleNodeUpRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        BalancerUtil.lookupBalancer(this.router, DynamicAdminPageInterceptor.getBalancerParam(params)).up(params.get("cluster"), params.get("host"), Integer.parseInt(params.get("port")));
        return this.redirect("clusters", "show", URLParamUtil.createQueryString("balancer", DynamicAdminPageInterceptor.getBalancerParam(params), "cluster", params.get("cluster")), relativeRootPath);
    }

    @Mapping(value="/admin/node/takeout/?(\\?.*)?")
    public Response handleNodeTakeoutRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        BalancerUtil.lookupBalancer(this.router, DynamicAdminPageInterceptor.getBalancerParam(params)).takeout(params.get("cluster"), params.get("host"), Integer.parseInt(params.get("port")));
        return this.redirect("clusters", "show", URLParamUtil.createQueryString("balancer", DynamicAdminPageInterceptor.getBalancerParam(params), "cluster", params.get("cluster")), relativeRootPath);
    }

    @Mapping(value="/admin/node/down/?(\\?.*)?")
    public Response handleNodeDownRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        BalancerUtil.lookupBalancer(this.router, DynamicAdminPageInterceptor.getBalancerParam(params)).down(params.get("cluster"), params.get("host"), Integer.parseInt(params.get("port")));
        return this.redirect("clusters", "show", URLParamUtil.createQueryString("balancer", DynamicAdminPageInterceptor.getBalancerParam(params), "cluster", params.get("cluster")), relativeRootPath);
    }

    @Mapping(value="/admin/node/delete/?(\\?.*)?")
    public Response handleNodeDeleteRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        if (this.readOnly) {
            return this.createReadOnlyErrorResponse();
        }
        BalancerUtil.lookupBalancer(this.router, DynamicAdminPageInterceptor.getBalancerParam(params)).removeNode(params.get("cluster"), params.get("host"), Integer.parseInt(params.get("port")));
        return this.redirect("clusters", "show", URLParamUtil.createQueryString("balancer", DynamicAdminPageInterceptor.getBalancerParam(params), "cluster", params.get("cluster")), relativeRootPath);
    }

    @Mapping(value="/admin/node/reset/?(\\?.*)?")
    public Response handleNodeResetRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        BalancerUtil.lookupBalancer(this.router, DynamicAdminPageInterceptor.getBalancerParam(params)).getNode(params.get("cluster"), params.get("host"), Integer.parseInt(params.get("port"))).clearCounter();
        return this.redirect("node", "show", URLParamUtil.createQueryString("balancer", DynamicAdminPageInterceptor.getBalancerParam(params), "cluster", params.get("cluster"), "host", params.get("host"), "port", params.get("port")), relativeRootPath);
    }

    @Mapping(value="/admin/statistics")
    public Response handleStatisticsRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        return this.respond(this.getStatisticsPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/streams")
    public Response handleStreamPumpsRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        return this.respond(this.getStreamPumpsPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/calls(/?\\?.*)?")
    public Response handleCallsRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        return this.respond(this.getCallsPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/call/?(\\?.*)?")
    public Response handleCallRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        return this.respond(this.getCallPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/clients")
    public Response handleClientsRequest(Map<String, String> params, String relativeRootPath) throws Exception {
        return this.respond(this.getClientsPage(params, relativeRootPath));
    }

    @Mapping(value="/admin/about")
    public Response getAbout(Map<String, String> params, String relativeRootPath) throws Exception {
        return this.respond(this.getAboutPage(params, relativeRootPath));
    }

    private String getServiceProxyPage(Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 0;
            }

            @Override
            protected void createTabContent() throws Exception {
                ((Html)((Html)this.h3()).text("ServiceProxies")).end();
                this.createFwdRulesTable();
                this.createAddFwdRuleForm();
            }
        }.createPage();
    }

    private String getProxyPage(Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 1;
            }

            @Override
            protected void createTabContent() throws Exception {
                ((Html)((Html)this.h3()).text("Proxies")).end();
                this.createProxyRulesTable();
                this.createAddProxyRuleForm();
            }
        }.createPage();
    }

    private String getClusterPage(final Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 4;
            }

            @Override
            protected void createTabContent() throws Exception {
                String balancer = DynamicAdminPageInterceptor.getBalancerParam(params);
                ((Html)((Html)this.h2()).text("Cluster " + (String)params.get("cluster") + " of Balancer " + balancer)).end();
                this.createNodesTable(balancer);
                this.createAddNodeForm(balancer);
            }
        }.createPage();
    }

    private String getClustersPage(final Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 4;
            }

            @Override
            protected void createTabContent() throws Exception {
                String balancer = DynamicAdminPageInterceptor.getBalancerParam(params);
                ((Html)((Html)this.h1()).text("Balancer " + balancer)).end();
                ((Html)((Html)this.h2()).text("Clusters")).end();
                this.createClustersTable(balancer);
                this.createAddClusterForm(balancer);
                this.p();
                this.text("Failover: ");
                this.text(BalancerUtil.lookupBalancerInterceptor(DynamicAdminPageInterceptor.this.router, balancer).isFailOver() ? "yes" : "no");
                this.end();
            }
        }.createPage();
    }

    private String getBalancersPage(Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 4;
            }

            @Override
            protected void createTabContent() throws Exception {
                ((Html)((Html)this.h1()).text("Balancers")).end();
                this.createBalancersTable();
            }
        }.createPage();
    }

    private String getStatisticsPage(Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 5;
            }

            @Override
            protected void createTabContent() throws Exception {
                ((Html)((Html)this.h3()).text("Statistics")).end();
                this.createStatisticsTable();
            }
        }.createPage();
    }

    private String getStreamPumpsPage(Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 7;
            }

            @Override
            protected void createTabContent() throws Exception {
                ((Html)((Html)this.h3()).text("Stream Pump Statistics")).end();
                this.createStreamPumpsTable();
            }
        }.createPage();
    }

    private String getCallsPage(final Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 6;
            }

            @Override
            protected void createTabContent() throws Exception {
                PropertyValueCollector propertyValues = new PropertyValueCollector();
                DynamicAdminPageInterceptor.this.router.getExchangeStore().collect(propertyValues);
                ((Html)((Html)this.h3()).text("Filter")).end();
                this.form();
                this.div();
                ((Html)((Html)((Html)((Html)((Html)this.span()).text("Method")).end()).select()).id("message-filter-method")).onchange("membrane.messageTable.fnDraw();");
                this.option("*", "*", true);
                for (String s : DynamicAdminPageInterceptor.this.sort(propertyValues.getMethods())) {
                    this.option(s, s, false);
                }
                this.end();
                ((Html)((Html)((Html)((Html)((Html)this.span()).text("Status Code")).end()).select()).id("message-filter-statuscode")).onchange("membrane.messageTable.fnDraw();");
                this.option("*", "*", true);
                for (Integer i : DynamicAdminPageInterceptor.this.sort(propertyValues.statusCodes)) {
                    this.option(i.toString(), i.toString(), false);
                }
                this.end(2);
                this.div();
                ((Html)((Html)((Html)((Html)((Html)this.span()).text("Proxy")).end()).select()).id("message-filter-proxy")).onchange("membrane.messageTable.fnDraw();");
                this.option("*", "*", !params.containsKey("proxy"));
                for (String s : DynamicAdminPageInterceptor.this.sort(propertyValues.getProxies())) {
                    this.option(s, s, s.equals(params.get("proxy")));
                }
                this.end();
                ((Html)((Html)((Html)((Html)((Html)this.span()).text("Client")).end()).select()).id("message-filter-client")).onchange("membrane.messageTable.fnDraw();");
                this.option("*", "*", !params.containsKey("client"));
                for (String s : DynamicAdminPageInterceptor.this.sort(propertyValues.getClients())) {
                    this.option(s, s, s.equals(params.get("client")));
                }
                this.end();
                ((Html)((Html)((Html)((Html)((Html)this.span()).text("Server")).end()).select()).id("message-filter-server")).onchange("membrane.messageTable.fnDraw();");
                this.option("*", "*", true);
                for (String s : DynamicAdminPageInterceptor.this.sort(propertyValues.getServers())) {
                    this.option(s == null ? "undefined" : s, s == null ? "" : s, false);
                }
                this.end(2);
                this.div();
                ((Html)((Html)((Html)((Html)((Html)this.span()).text("Request Content-Type")).end()).select()).id("message-filter-reqcontenttype")).onchange("membrane.messageTable.fnDraw();");
                this.option("*", "*", true);
                for (String s : DynamicAdminPageInterceptor.this.sort(propertyValues.getReqContentTypes())) {
                    this.option(s.isEmpty() ? "undefined" : s, s, false);
                }
                this.end();
                ((Html)((Html)((Html)((Html)((Html)this.span()).text("Response Content-Type")).end()).select()).id("message-filter-respcontenttype")).onchange("membrane.messageTable.fnDraw();");
                this.option("*", "*", true);
                for (String s : DynamicAdminPageInterceptor.this.sort(propertyValues.getRespContentTypes())) {
                    this.option(s.isEmpty() ? "undefined" : s, s, false);
                }
                this.end(2);
                this.br();
                this.createButton("Reset Filter", "calls", null, null);
                ((Html)((Html)((Html)((Html)this.a()).id("reload-data-button")).classAttr("mb-button")).text("Reload data")).end();
                ((Html)((Html)((Html)((Html)((Html)((Html)this.label()).forAttr("reload-data-checkbox")).checkbox()).checked("true")).id("reload-data-checkbox")).text("Auto Reload")).end();
                this.end();
                this.addMessageText();
                this.createMessageStatisticsTable();
            }

            private void addMessageText() {
                if (!(DynamicAdminPageInterceptor.this.router.getExchangeStore() instanceof LimitedMemoryExchangeStore)) {
                    ((Html)((Html)this.h3()).text("Messages")).end();
                }
                if (DynamicAdminPageInterceptor.this.router.getExchangeStore() instanceof LimitedMemoryExchangeStore) {
                    ((Html)((Html)((Html)((Html)((Html)this.h3()).text(this.getLimitedMemoryExchangeStoreMessageText())).a()).href("http://www.membrane-soa.org/service-proxy-doc/4.2/configuration/reference/limitedMemoryExchangeStore.htm")).text("(What is this?)")).end(2);
                }
            }

            private String getLimitedMemoryExchangeStoreMessageText() {
                LimitedMemoryExchangeStore lmes = (LimitedMemoryExchangeStore)DynamicAdminPageInterceptor.this.router.getExchangeStore();
                float usage = 100.0f * (float)lmes.getCurrentSize() / (float)lmes.getMaxSize();
                Long oldestTimeResSent = lmes.getOldestTimeResSent();
                String usageStr = oldestTimeResSent == null ? "" : String.format("; usage %.0f%%; the last %s", Float.valueOf(usage), DateUtil.prettyPrintTimeSpan(System.currentTimeMillis() - oldestTimeResSent));
                return "Messages" + String.format(" (limited to last %.2f MB%s)", (double)lmes.getMaxSize() / 1000000.0, usageStr);
            }
        }.createPage();
    }

    private <T extends Comparable<? super T>> List<T> sort(Set<T> data) {
        int nulls = 0;
        ArrayList<Comparable> res = new ArrayList<Comparable>(data.size());
        for (Comparable t : data) {
            if (t == null) {
                ++nulls;
                continue;
            }
            res.add(t);
        }
        Collections.sort(res);
        while (nulls-- > 0) {
            res.add(0, null);
        }
        return res;
    }

    private String getCallPage(final Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 6;
            }

            @Override
            protected void createTabContent() throws Exception {
                ((Html)((Html)this.script()).raw("$(function() {\r\n\t\t\t\t\t$( \"#exchangeTab\" ).tabs();\r\n\t\t\t\t\t$( \"#requestContentTab\" ).tabs();\r\n\t\t\t\t\t$( \"#responseContentTab\" ).tabs();\r\n                   membrane.loadExchange(" + (String)params.get("id") + ");\r\n" + "\t\t\t\t});")).end();
                ((Html)this.div()).id("exchangeTab");
                this.ul();
                ((Html)((Html)((Html)((Html)this.li()).a()).href("#tab1")).text("Request")).end(2);
                ((Html)((Html)((Html)((Html)this.li()).a()).href("#tab2")).text("Response")).end(2);
                this.end();
                ((Html)this.div()).id("tab1");
                this.creatExchangeMetaTable("request-meta");
                ((Html)((Html)this.h3()).text("Content")).end();
                ((Html)((Html)((Html)((Html)((Html)((Html)this.div()).align("right")).a()).id("request-download-button")).text("Download")).end()).end();
                ((Html)this.div()).id("requestContentTab");
                this.ul();
                ((Html)((Html)((Html)((Html)this.li()).a()).href("#requestRawTab")).text("Raw")).end(2);
                ((Html)((Html)((Html)((Html)this.li()).a()).href("#requestHeadersTab")).text("Headers")).end(2);
                ((Html)((Html)((Html)((Html)this.li()).a()).href("#requestBodyTab")).text("Body")).end(2);
                this.end();
                ((Html)this.div()).id("requestRawTab");
                ((Html)((Html)((Html)((Html)((Html)this.div()).classAttr("proxy-config")).pre()).id("request-raw")).end()).end();
                this.end();
                ((Html)this.div()).id("requestHeadersTab");
                this.creatHeaderTable("request-headers");
                this.end();
                ((Html)this.div()).id("requestBodyTab");
                ((Html)((Html)((Html)((Html)((Html)this.div()).classAttr("proxy-config")).pre()).id("request-body")).end()).end();
                this.end();
                this.end();
                this.end();
                ((Html)this.div()).id("tab2");
                this.creatExchangeMetaTable("response-meta");
                ((Html)((Html)this.h3()).text("Content")).end();
                ((Html)((Html)((Html)((Html)((Html)((Html)this.div()).align("right")).a()).id("response-download-button")).text("Download")).end()).end();
                ((Html)this.div()).id("responseContentTab");
                this.ul();
                ((Html)((Html)((Html)((Html)this.li()).a()).href("#responseRawTab")).text("Raw")).end(2);
                ((Html)((Html)((Html)((Html)this.li()).a()).href("#responseHeadersTab")).text("Headers")).end(2);
                ((Html)((Html)((Html)((Html)this.li()).a()).href("#responseBodyTab")).text("Body")).end(2);
                this.end();
                ((Html)this.div()).id("responseRawTab");
                ((Html)((Html)((Html)((Html)((Html)this.div()).classAttr("proxy-config")).pre()).id("response-raw")).end()).end();
                this.end();
                ((Html)this.div()).id("responseHeadersTab");
                this.creatHeaderTable("response-headers");
                this.end();
                ((Html)this.div()).id("responseBodyTab");
                ((Html)((Html)((Html)((Html)((Html)this.div()).classAttr("proxy-config")).pre()).id("response-body")).end()).end();
                this.end();
                this.end();
                this.end();
                this.end();
            }
        }.createPage();
    }

    private String getClientsPage(Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 8;
            }

            @Override
            protected void createTabContent() throws Exception {
                ((Html)((Html)this.h3()).text("Statistics")).end();
                this.createClientsStatisticsTable();
            }
        }.createPage();
    }

    private String getAboutPage(Map<String, String> params, String relativeRootPath) throws Exception {
        StringWriter writer = new StringWriter();
        return new AdminPageBuilder(writer, this.router, relativeRootPath, params, this.readOnly){

            @Override
            protected int getSelectedTab() {
                return 9;
            }

            @Override
            protected void createTabContent() throws Exception {
                ((Html)((Html)this.h3()).text("Impressum")).end();
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.p()).text("predic8 GmbH")).br()).text("Moltkestr. 40")).br()).br()).text("53173 Bonn")).end();
            }
        }.createPage();
    }

    private Outcome dispatchRequest(Exchange exc) throws Exception {
        String pathQuery = URLUtil.getPathQuery(this.router.getUriFactory(), exc.getDestinations().get(0));
        for (Method m : this.getClass().getMethods()) {
            Mapping a = m.getAnnotation(Mapping.class);
            if (a == null || !Pattern.matches(a.value(), pathQuery)) continue;
            exc.setResponse((Response)m.invoke((Object)this, this.getParams(exc), RESTInterceptor.getRelativeRootPath(pathQuery)));
            return Outcome.RETURN;
        }
        return Outcome.CONTINUE;
    }

    private Map<String, String> getParams(Exchange exc) throws Exception {
        return URLParamUtil.getParams(this.router.getUriFactory(), exc);
    }

    private Response respond(String page) throws Exception {
        return HttpUtil.createResponse(200, "OK", page.getBytes(Constants.UTF_8_CHARSET), "text/html;charset=UTF-8", new String[0]);
    }

    private Response redirect(String ctrl, String action, String query, String relativeRootPath) throws Exception {
        return HttpUtil.createResponse(302, "Found", null, "text/html;charset=UTF-8", "Location", relativeRootPath + AdminPageBuilder.createHRef(ctrl, action, query));
    }

    private int getPortParam(Map<String, String> params) {
        return Integer.parseInt(params.get("port"));
    }

    private int getTargetPortParam(Map<String, String> params) {
        return Integer.parseInt(params.get("targetPort"));
    }

    public static String getBalancerParam(Map<String, String> params) {
        String balancerName = params.get("balancer");
        if (balancerName == null) {
            balancerName = "Default";
        }
        return balancerName;
    }

    private void logAddFwdRuleParams(Map<String, String> params) {
        log.debug("adding fwd rule");
        log.debug("name: " + params.get("name"));
        log.debug("port: " + params.get("port"));
        log.debug("client host: " + params.get("clientHost"));
        log.debug("method: " + params.get("method"));
        log.debug("path: " + params.get("path"));
        log.debug("target host: " + params.get("targetHost"));
        log.debug("target port: " + params.get("targetPort"));
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Response createReadOnlyErrorResponse() {
        return Response.forbidden("The admin console is configured to be readOnly.").build();
    }
}

