/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.administration;

import com.googlecode.jatl.Html;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.administration.DynamicAdminPageInterceptor;
import com.predic8.membrane.core.interceptor.administration.RuleUtil;
import com.predic8.membrane.core.interceptor.balancer.Balancer;
import com.predic8.membrane.core.interceptor.balancer.BalancerUtil;
import com.predic8.membrane.core.interceptor.balancer.Cluster;
import com.predic8.membrane.core.interceptor.balancer.LoadBalancingInterceptor;
import com.predic8.membrane.core.interceptor.balancer.Node;
import com.predic8.membrane.core.interceptor.balancer.Session;
import com.predic8.membrane.core.interceptor.flow.RequestInterceptor;
import com.predic8.membrane.core.interceptor.flow.ResponseInterceptor;
import com.predic8.membrane.core.rules.AbstractProxy;
import com.predic8.membrane.core.rules.AbstractServiceProxy;
import com.predic8.membrane.core.rules.ProxyRule;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.StatisticCollector;
import com.predic8.membrane.core.transport.http.StreamPump;
import com.predic8.membrane.core.util.TextUtil;
import com.predic8.membrane.core.util.URLParamUtil;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.time.DurationFormatUtils;

public class AdminPageBuilder
extends Html {
    static final int TAB_ID_SERVICE_PROXIES = 0;
    static final int TAB_ID_PROXIES = 1;
    static final int TAB_ID_TRANSPORT = 2;
    static final int TAB_ID_SYSTEM = 3;
    static final int TAB_ID_LOAD_BALANCING = 4;
    static final int TAB_ID_STATISTICS = 5;
    static final int TAB_ID_CALLS = 6;
    static final int TAB_ID_STREAM_PUMPS = 7;
    static final int TAB_ID_CLIENTS = 8;
    static final int TAB_ID_ABOUT = 9;
    private final Router router;
    private final Map<String, String> params;
    private final StringWriter writer;
    private final String relativeRootPath;
    private final boolean readOnly;
    private HashMap<StatisticCollector, String> numberOfBackendConnections = new HashMap();

    public static String createHRef(String ctrl, String action, String query) {
        return "/admin/" + ctrl + (action != null ? "/" + action : "") + (query != null ? "?" + query : "");
    }

    public AdminPageBuilder(StringWriter writer, Router router, String relativeRootPath, Map<String, String> params, boolean readOnly) {
        super((Writer)writer);
        this.router = router;
        this.params = params;
        this.writer = writer;
        this.relativeRootPath = relativeRootPath;
        this.readOnly = readOnly;
    }

    private String makeRelative(String path) {
        if (path.startsWith("/")) {
            return this.relativeRootPath + path;
        }
        return path;
    }

    public Html action(String value) {
        return (Html)super.action(this.makeRelative(value));
    }

    public Html src(String value) {
        return (Html)super.src(this.makeRelative(value));
    }

    public Html href(String value) {
        return (Html)super.href(this.makeRelative(value));
    }

    public String createPage() throws Exception {
        this.html();
        this.createHead();
        this.body();
        ((Html)((Html)this.div()).id("tabs")).classAttr("ui-tabs ui-widget ui-widget-content ui-corner-all");
        this.createTabs(this.getSelectedTab());
        ((Html)this.div()).classAttr("ui-tabs-panel ui-widget-content ui-corner-bottom");
        this.createTabContent();
        this.end();
        ((Html)((Html)((Html)this.p()).classAttr("footer")).raw("Copyright \u00a92009-2016 <a href=\"http://predic8.com/\">predic8 GmbH</a>. All Rights Reserved. See <a href=\"http://www.membrane-soa.org/service-proxy/\">http://www.membrane-soa.org/service-proxy/</a> for documentation and updates.")).end();
        this.end();
        this.endAll();
        this.done();
        return this.writer.getBuffer().toString();
    }

    protected String getTitle() {
        return "Membrane Service Proxy Administration";
    }

    protected int getSelectedTab() {
        return 0;
    }

    protected void createTabContent() throws Exception {
    }

    protected void createHead() {
        this.head();
        ((Html)((Html)this.title()).text(this.getTitle())).end();
        ((Html)((Html)((Html)this.style()).attr(new String[]{"type", "text/css"})).text("@import '" + this.relativeRootPath + "/admin/datatables/css/demo_table_jui.css';\n" + "@import '" + this.relativeRootPath + "/admin/jquery-ui/css/custom-theme/jquery-ui-1.8.13.custom.css';" + "@import '" + this.relativeRootPath + "/admin/css/membrane.css';")).end();
        ((Html)((Html)((Html)this.link()).rel("stylesheet")).href("/admin/formValidator/validationEngine.jquery.css")).type("text/css");
        ((Html)((Html)((Html)this.script()).attr(new String[]{"type", "text/javascript"})).src("/admin/jquery/jquery-1.6.1.js")).end();
        ((Html)((Html)((Html)this.script()).attr(new String[]{"type", "text/javascript"})).src("/admin/datatables/js/jquery.dataTables.min.js")).end();
        ((Html)((Html)((Html)this.script()).attr(new String[]{"type", "text/javascript"})).src("/admin/jquery-ui/js/jquery-ui-1.8.13.custom.min.js")).end();
        ((Html)((Html)((Html)this.script()).attr(new String[]{"type", "text/javascript"})).src("/admin/formValidator/jquery.validationEngine-en.js")).end();
        ((Html)((Html)((Html)this.script()).attr(new String[]{"type", "text/javascript"})).src("/admin/formValidator/jquery.validationEngine.js")).end();
        ((Html)((Html)((Html)this.script()).attr(new String[]{"type", "text/javascript"})).raw("var relativeRootPath=\"" + StringEscapeUtils.escapeJavaScript((String)this.relativeRootPath) + "\";")).end();
        ((Html)((Html)((Html)this.script()).attr(new String[]{"type", "text/javascript"})).src("/admin/js/membrane.js")).end();
        this.createMetaElements();
        this.end();
    }

    protected void createMetaElements() {
        ((Html)((Html)this.meta()).attr(new String[]{"http-equiv", "X-UA-Compatible", "content", "IE=Edge"})).end();
        if (this.params.containsKey("refresh")) {
            try {
                this.createMeta("refresh", "" + Integer.parseInt(this.params.get("refresh")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void createMeta(String ... meta) {
        for (int i = 0; i < meta.length; i += 2) {
            ((Html)((Html)((Html)this.meta()).httpEquiv(meta[i])).content(meta[i + 1])).end();
        }
    }

    protected void createInterceptorTable(List<Interceptor> interceptors) {
        ((Html)((Html)this.table()).id("interceptortable")).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display", "id", "interceptor-table"});
        this.thead();
        this.tr();
        this.createThs("Order", "Name");
        this.end();
        this.end();
        this.tbody();
        int j = 0;
        for (Interceptor i : interceptors) {
            this.tr();
            this.createTds("" + ++j, i.getDisplayName());
            this.end();
        }
        this.end();
        this.end();
    }

    protected void createAddFwdRuleForm() {
        if (this.readOnly) {
            return;
        }
        if (!this.router.getTransport().isOpeningPorts()) {
            return;
        }
        ((Html)((Html)((Html)this.form()).id("addFwdRuleForm")).action("/admin/service-proxy/save")).method("POST");
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.div()).span()).text("Name")).end()).span()).input()).type("text")).id("name")).name("name")).classAttr("validate[required]")).end(2)).span()).text("Listen Port")).end()).span()).input()).type("text")).id("port")).name("port")).size("5")).classAttr("validate[required,custom[integer]]")).end(2)).span()).text("Method")).end()).span()).select()).id("method")).name("method")).option()).text("*")).end()).option()).text("GET")).end()).option()).text("POST")).end()).option()).text("DELETE")).end()).end(2)).span()).text("Target Host")).end()).span()).input()).type("text")).id("targetHost")).name("targetHost")).classAttr("validate[required]")).end(2)).span()).text("Target Port")).end()).span()).input()).type("text")).id("targetPort")).name("targetPort")).size("5")).classAttr("validate[required,custom[integer]]")).end(2)).span()).input()).value("Add")).type("submit")).classAttr("mb-button")).end(2);
        this.end();
        this.end();
    }

    protected void createAddProxyRuleForm() {
        if (this.readOnly) {
            return;
        }
        ((Html)((Html)((Html)this.form()).id("addProxyRuleForm")).action("/admin/proxy/save")).method("POST");
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.div()).span()).text("Name")).end()).span()).input()).type("text")).id("p-name")).name("name")).classAttr("validate[required]")).end(2)).span()).text("Listen Port")).end()).span()).input()).type("text")).id("p-port")).name("port")).size("5")).classAttr("validate[required,custom[integer]]")).end(2)).span()).input()).value("Add")).type("submit")).classAttr("mb-button")).end(2);
        this.end();
        this.end();
    }

    protected void createFwdRulesTable() throws UnsupportedEncodingException {
        ((Html)this.table()).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display", "id", "fwdrules-table"});
        this.thead();
        this.tr();
        this.createThs("Order", "Name", "Listen Port", "Virtual Host", "Method", "Path", "Target Host", "Target Port", "Count", "Actions");
        this.end();
        this.end();
        this.tbody();
        this.end();
        this.end();
    }

    protected void createProxyRulesTable() throws UnsupportedEncodingException {
        ((Html)this.table()).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display", "id", "proxy-rules-table"});
        this.thead();
        this.tr();
        this.createThs("Name", "Listen Port", "Count", "Actions");
        this.end();
        this.end();
        this.tbody();
        for (ProxyRule rule : this.getProxyRules()) {
            this.tr();
            this.td();
            this.createLink(rule.toString(), "proxy", "show", URLParamUtil.createQueryString("name", RuleUtil.getRuleIdentifier(rule)));
            this.end();
            this.createTds(rule.getKey().getPort() == -1 ? "" : "" + rule.getKey().getPort(), "" + rule.getCount());
            if (!this.readOnly) {
                ((Html)((Html)((Html)((Html)((Html)this.td()).a()).href("/admin/proxy/delete?name=" + URLEncoder.encode(RuleUtil.getRuleIdentifier(rule), "UTF-8"))).span()).classAttr("ui-icon ui-icon-trash")).end(3);
            }
            this.end();
        }
        this.end();
        this.end();
    }

    protected void createTabs(int selected) throws Exception {
        ((Html)this.ul()).classAttr("ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all");
        ((Html)this.li()).classAttr(this.getSelectedTabStyle(0, selected));
        ((Html)((Html)((Html)this.a()).href("/admin")).text("ServiceProxies")).end();
        this.end();
        ((Html)this.li()).classAttr(this.getSelectedTabStyle(1, selected));
        this.createLink("Proxies", "proxy", null, null);
        this.end();
        ((Html)this.li()).classAttr(this.getSelectedTabStyle(2, selected));
        this.createLink("Transport", "transport", null, null);
        this.end();
        ((Html)this.li()).classAttr(this.getSelectedTabStyle(3, selected));
        this.createLink("System", "system", null, null);
        this.end();
        if (BalancerUtil.hasLoadBalancing(this.router)) {
            ((Html)this.li()).classAttr(this.getSelectedTabStyle(4, selected));
            this.createLink("Load Balancing", "balancers", null, null);
            this.end();
        }
        ((Html)this.li()).classAttr(this.getSelectedTabStyle(5, selected));
        this.createLink("Statistics", "statistics", null, null);
        this.end();
        ((Html)this.li()).classAttr(this.getSelectedTabStyle(6, selected));
        this.createLink("Calls", "calls", null, null);
        this.end();
        ((Html)this.li()).classAttr(this.getSelectedTabStyle(7, selected));
        this.createLink("Stream Pumps", "streams", null, null);
        this.end();
        ((Html)this.li()).classAttr(this.getSelectedTabStyle(8, selected));
        this.createLink("Clients", "clients", null, null);
        this.end();
        ((Html)((Html)this.li()).style("float: right;")).classAttr(this.getSelectedTabStyle(9, selected));
        this.createLink("About", "about", null, null);
        this.end();
        this.end();
    }

    protected void createAddClusterForm(String balancerName) {
        if (this.readOnly) {
            return;
        }
        ((Html)((Html)((Html)this.form()).id("addClusterForm")).action("/admin/clusters/save")).method("POST");
        ((Html)((Html)((Html)((Html)this.input()).type("hidden")).name("balancer")).value(balancerName)).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.div()).span()).text("Name")).end()).span()).input()).type("text")).id("name")).name("name")).classAttr("validate[required]")).end(2)).span()).input()).value("Add Cluster")).type("submit")).classAttr("mb-button")).end(2);
        this.end();
        this.end();
    }

    protected void createBalancersTable() throws UnsupportedEncodingException {
        ((Html)this.table()).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display balancersTable"});
        this.thead();
        this.tr();
        this.createThs("Name", "Failover", "Health");
        this.end();
        this.end();
        this.tbody();
        for (LoadBalancingInterceptor loadBalancingInterceptor : BalancerUtil.collectBalancers(this.router)) {
            this.tr();
            this.td();
            this.createLink(loadBalancingInterceptor.getName(), "clusters", null, URLParamUtil.createQueryString("balancer", loadBalancingInterceptor.getName()));
            this.end();
            this.createTds(loadBalancingInterceptor.isFailOver() ? "yes" : "no", this.getFormatedHealth(loadBalancingInterceptor.getName()));
            this.end();
        }
        this.end();
        this.end();
    }

    protected void createClustersTable(String balancerName) throws UnsupportedEncodingException {
        ((Html)this.table()).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display clustersTable"});
        this.thead();
        this.tr();
        this.createThs("Name", "#Nodes", "Health");
        this.end();
        this.end();
        this.tbody();
        for (Cluster c : BalancerUtil.lookupBalancer(this.router, balancerName).getClusters()) {
            this.tr();
            this.td();
            this.createLink(!c.getName().isEmpty() ? c.getName() : "<unnamed>", "clusters", "show", URLParamUtil.createQueryString("balancer", balancerName, "cluster", c.getName()));
            this.end();
            this.createTds(String.valueOf(BalancerUtil.lookupBalancer(this.router, balancerName).getAllNodesByCluster(c.getName()).size()), this.getFormatedHealth(balancerName, c.getName()));
            this.end();
        }
        this.end();
        this.end();
    }

    protected void createAddNodeForm(String balancerName) {
        if (this.readOnly) {
            return;
        }
        ((Html)((Html)((Html)this.form()).id("addNodeForm")).action("/admin/node/save")).method("POST");
        ((Html)((Html)((Html)((Html)this.input()).type("hidden")).name("balancer")).value(balancerName)).end();
        ((Html)((Html)((Html)((Html)this.input()).type("hidden")).name("cluster")).value(this.params.get("cluster"))).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)this.div()).span()).text("Host")).end()).span()).input()).type("text")).id("host")).name("host")).classAttr("validate[required]")).end(2)).span()).text("Port")).end()).span()).input()).type("text")).id("port")).name("port")).size("5")).classAttr("validate[required,custom[integer]]")).end(2)).span()).input()).value("Add Node")).type("submit")).classAttr("mb-button")).end(2);
        this.end();
        this.end();
    }

    protected void createSessionsTable(List<Session> sessions) {
        ((Html)this.table()).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display sessionsTable"});
        this.thead();
        this.tr();
        this.createThs("Id", "Last Used");
        this.end();
        this.end();
        this.tbody();
        for (Session s : sessions) {
            this.tr();
            this.createTds(s.getId(), DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - s.getLastUsed())));
            this.end();
        }
        this.end();
        this.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createStatusCodesTable(Map<Integer, StatisticCollector> statusCodes) throws Exception {
        ((Html)this.table()).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display", "id", "statuscode-table"});
        this.thead();
        this.tr();
        this.createThs("Status Code", "Count", "Minimum Time", "Maximum Time", "Average Time", "Total Request Body Bytes", "Total Response Body Bytes");
        this.end();
        this.end();
        this.tbody();
        Map<Integer, StatisticCollector> map = statusCodes;
        synchronized (map) {
            for (Map.Entry<Integer, StatisticCollector> codes : statusCodes.entrySet()) {
                StatisticCollector statisticCollector = codes.getValue();
                ((Html)this.tr()).style("text-align: right;");
                ((Html)((Html)((Html)this.td()).style("text-align:left;")).text("" + codes.getKey())).end();
                this.createTds("" + statisticCollector.getCount(), "" + statisticCollector.getMinTime(), "" + statisticCollector.getMaxTime(), "" + statisticCollector.getAvgTime(), "" + statisticCollector.getBytesSent(), "" + statisticCollector.getBytesReceived());
                this.end();
            }
        }
        this.end();
        this.end();
    }

    protected void createStatisticsTable() throws UnsupportedEncodingException {
        ((Html)this.table()).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display", "id", "statistics-table"});
        this.thead();
        this.tr();
        this.createThs("Name", "Count", "Minimum Time", "Maximum Time", "Average Time", "Total Request Body Bytes", "Total Response Body Bytes", "Open Connections");
        this.end();
        this.end();
        this.tbody();
        for (Map.Entry<String, StatisticCollector> entry : this.getStatistics().entrySet()) {
            StatisticCollector statisticCollector = entry.getValue();
            ((Html)this.tr()).style("text-align: right;");
            ((Html)((Html)((Html)this.td()).style("text-align:left;")).text(entry.getKey())).end();
            this.createTds("" + statisticCollector.getCount(), "" + statisticCollector.getMinTime(), "" + statisticCollector.getMaxTime(), "" + statisticCollector.getAvgTime(), "" + statisticCollector.getBytesSent(), "" + statisticCollector.getBytesReceived(), "" + this.getBackendConnections(statisticCollector));
            this.end();
        }
        this.end();
        this.end();
    }

    private String getBackendConnections(StatisticCollector statisticCollector) {
        return this.numberOfBackendConnections.get(statisticCollector);
    }

    protected void createStreamPumpsTable() throws UnsupportedEncodingException {
        ((Html)this.table()).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display", "id", "stream-pumps-table"});
        this.thead();
        this.tr();
        this.createThs("Name", "Service Proxy", "Creation Time", "Active Time", "Transferred Bytes");
        this.end();
        this.end();
        this.tbody();
        for (StreamPump p : this.router.getStatistics().getStreamPumpStats().getStreamPumps()) {
            ((Html)this.tr()).style("text-align: right;");
            ((Html)((Html)((Html)this.td()).style("text-align:left;")).text(p.getName())).end();
            this.createTds(p.getServiceProxyName(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(p.getCreationTime()), (System.currentTimeMillis() - p.getCreationTime()) / 1000L + " seconds", "" + p.getTransferredBytes());
            this.end();
        }
        this.end();
        this.end();
    }

    protected void createNodesTable(String balancerName) throws Exception {
        ((Html)this.table()).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display nodesTable"});
        this.thead();
        this.tr();
        this.createThs("Node", "Status", "Count", "Errors", "Time since last up", "Sessions", "Current Threads", "Action");
        this.end();
        this.end();
        this.tbody();
        for (Node n : BalancerUtil.lookupBalancer(this.router, balancerName).getAllNodesByCluster(this.params.get("cluster"))) {
            this.tr();
            this.td();
            this.createLink("" + n.getHost() + ":" + n.getPort(), "node", "show", URLParamUtil.createQueryString("balancer", balancerName, "cluster", this.params.get("cluster"), "host", n.getHost(), "port", "" + n.getPort()));
            this.end();
            this.createTds(this.getStatusString(n), "" + n.getCounter(), String.format("%1$.2f%%", n.getErrors() * 100.0), DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - n.getLastUpTime())), "" + BalancerUtil.lookupBalancer(this.router, balancerName).getSessionsByNode(this.params.get("cluster"), n).size(), "" + n.getThreads());
            this.td();
            this.createIcon("ui-icon-eject", "node", "takeout", "takeout", this.createQuery4Node(n));
            this.createIcon("ui-icon-circle-arrow-n", "node", "up", "up", this.createQuery4Node(n));
            this.createIcon("ui-icon-circle-arrow-s", "node", "down", "down", this.createQuery4Node(n));
            if (!this.readOnly) {
                this.createIcon("ui-icon-trash", "node", "delete", "delete", this.createQuery4Node(n));
            }
            this.end();
            this.end();
        }
        this.end();
        this.end();
        ((Html)((Html)this.script()).raw("$(document).ready(function() { $('.nodesTable').dataTable({'bJQueryUI': true, \"bPaginate\": false}); } );")).end();
    }

    private String getStatusString(Node n) {
        switch (n.getStatus()) {
            case TAKEOUT: {
                return "In take out";
            }
        }
        return "" + (Object)((Object)n.getStatus());
    }

    private String createQuery4Node(Node n) throws UnsupportedEncodingException {
        return URLParamUtil.createQueryString("balancer", DynamicAdminPageInterceptor.getBalancerParam(this.params), "cluster", this.params.get("cluster"), "host", n.getHost(), "port", "" + n.getPort());
    }

    private void createIcon(String icon, String ctrl, String action, String tooltip, String query) {
        ((Html)((Html)((Html)((Html)((Html)((Html)this.a()).href(AdminPageBuilder.createHRef(ctrl, action, query))).span()).classAttr("ui-icon " + icon)).style("float:left;")).title(tooltip)).end(2);
    }

    private String getFormatedHealth(String balancerName, String cluster) {
        return String.format("%d up/ %d down", BalancerUtil.lookupBalancer(this.router, balancerName).getAvailableNodesByCluster(cluster).size(), BalancerUtil.lookupBalancer(this.router, balancerName).getAllNodesByCluster(cluster).size() - BalancerUtil.lookupBalancer(this.router, balancerName).getAvailableNodesByCluster(cluster).size());
    }

    private String getFormatedHealth(String balancerName) {
        Balancer balancer = BalancerUtil.lookupBalancer(this.router, balancerName);
        int available = 0;
        int all = 0;
        for (Cluster c : balancer.getClusters()) {
            all += balancer.getAllNodesByCluster(c.getName()).size();
            available += balancer.getAvailableNodesByCluster(c.getName()).size();
        }
        return String.format("%d up/ %d down", available, all - available);
    }

    private String getSelectedTabStyle(int ownPos, int selected) {
        return ownPos == selected ? "ui-state-default ui-corner-top ui-tabs-selected ui-state-active" : "ui-state-default ui-corner-top";
    }

    private List<ProxyRule> getProxyRules() {
        LinkedList<ProxyRule> rules = new LinkedList<ProxyRule>();
        for (Rule r : this.router.getRuleManager().getRules()) {
            if (!(r instanceof ProxyRule)) continue;
            rules.add((ProxyRule)r);
        }
        return rules;
    }

    private Map<String, StatisticCollector> getStatistics() {
        TreeMap<String, StatisticCollector> res = new TreeMap<String, StatisticCollector>();
        HashMap<StatisticCollector, String> backendConnections = new HashMap<StatisticCollector, String>();
        for (Rule r : this.router.getRuleManager().getRules()) {
            if (!(r instanceof AbstractProxy)) continue;
            StatisticCollector sc = new StatisticCollector(true);
            for (StatisticCollector s : ((AbstractProxy)r).getStatisticsByStatusCodes().values()) {
                sc.collectFrom(s);
            }
            res.put(r.getName(), sc);
            backendConnections.put(sc, this.router.getTransport().getOpenBackendConnections(r.getKey().getPort()));
        }
        this.numberOfBackendConnections = backendConnections;
        return res;
    }

    protected void createButton(String label, String ctrl, String action, String query) throws UnsupportedEncodingException {
        ((Html)((Html)((Html)((Html)this.a()).classAttr("mb-button")).href(AdminPageBuilder.createHRef(ctrl, action, query))).text(label)).end();
    }

    protected void createLink(String label, String ctrl, String action, String query) throws UnsupportedEncodingException {
        ((Html)((Html)((Html)this.a()).href(AdminPageBuilder.createHRef(ctrl, action, query))).text(label)).end();
    }

    protected void createThs(String ... data) {
        for (String d : data) {
            ((Html)((Html)this.th()).text(d)).end();
        }
    }

    protected void createTds(String ... data) {
        for (String d : data) {
            ((Html)((Html)this.td()).text(d)).end();
        }
    }

    protected void createTr(String ... data) {
        this.tr();
        for (String d : data) {
            ((Html)((Html)this.td()).text(d)).end();
        }
        this.end();
    }

    private void createInterceptorVisualization(Interceptor i, int columnSpan, String id, boolean noMarginTop) {
        ((Html)this.td()).style("padding:0px;");
        if (columnSpan > 1) {
            this.colspan("" + columnSpan);
        }
        if (i == null) {
            ((Html)this.div()).style("padding:2px 5px; margin: 10px; width: 299px;");
            this.raw("&nbsp;");
            this.end();
        } else {
            String shortDescription = i.getShortDescription();
            String longDescription = i.getLongDescription();
            boolean same = longDescription.equals(shortDescription);
            if (!TextUtil.isValidXMLSnippet(shortDescription)) {
                shortDescription = StringEscapeUtils.escapeHtml((String)shortDescription).replace("\n", "<br/>");
                if (same) {
                    longDescription = shortDescription;
                }
            }
            if (!same && !TextUtil.isValidXMLSnippet(longDescription)) {
                longDescription = StringEscapeUtils.escapeHtml((String)longDescription).replace("\n", "<br/>");
            }
            shortDescription = shortDescription.replaceAll("\"/admin", "\"" + this.relativeRootPath + "/admin");
            longDescription = longDescription.replaceAll("\"/admin", "\"" + this.relativeRootPath + "/admin");
            String did = "d" + id;
            ((Html)((Html)this.div()).id(did)).style("border: 1px solid black; padding:8px 5px; margin: 10px;overflow-x: auto; background-color: #FFC04F;" + (columnSpan == 1 ? "width: 299px;" : "width: 630px;") + (noMarginTop ? "margin-top: 0px;" : ""));
            String iid = "i" + id;
            ((Html)this.div()).id("i" + id);
            this.createHelpIcon(i, id);
            if (shortDescription.length() > 0 && !longDescription.equals(shortDescription)) {
                this.createExpandIcon(i, id);
            }
            this.end();
            this.createShowIconsScript(did, iid);
            ((Html)this.div()).classAttr("name");
            this.text(i.getDisplayName());
            this.end();
            if (shortDescription.length() > 0) {
                ((Html)this.div()).style("padding-top: 4px;");
                String sid = "s" + id;
                ((Html)this.div()).id(sid);
                this.raw(shortDescription);
                if (!longDescription.equals(shortDescription)) {
                    String aid = "a" + id;
                    String lid = "l" + id;
                    String eid = "e" + id;
                    String cid = "c" + id;
                    ((Html)((Html)((Html)((Html)this.a()).id(aid)).href("#")).text("...")).end();
                    this.end();
                    ((Html)((Html)this.div()).id(lid)).style("margin: 0px;");
                    this.raw(longDescription);
                    this.end();
                    this.script();
                    this.raw("jQuery(document).ready(function() {\r\n  jQuery(\"#" + eid + "\").css('cursor', 'pointer');\r\n" + "  jQuery(\"#" + cid + "\").css('cursor', 'pointer');\r\n" + "  jQuery(\"#" + lid + "\").hide();\r\n" + "  jQuery(\"#" + cid + "\").hide();\r\n" + "  jQuery(\"#" + eid + "\").click(function()\r\n" + "  {\r\n" + "    jQuery(\"#" + sid + "\").hide();\r\n" + "    jQuery(\"#" + lid + "\").slideToggle(500);\r\n" + "    jQuery(\"#" + eid + "\").hide();\r\n" + "    jQuery(\"#" + cid + "\").show();\r\n" + "  });\r\n" + "  jQuery(\"#" + aid + "\").click(function()\r\n" + "  {\r\n" + "    jQuery(\"#" + sid + "\").hide();\r\n" + "    jQuery(\"#" + lid + "\").slideToggle(500);\r\n" + "    jQuery(\"#" + eid + "\").hide();\r\n" + "    jQuery(\"#" + cid + "\").show();\r\n" + "  });\r\n" + "  jQuery(\"#" + cid + "\").click(function()\r\n" + "  {\r\n" + "    jQuery(\"#" + sid + "\").show();\r\n" + "    jQuery(\"#" + lid + "\").slideToggle(500);\r\n" + "    jQuery(\"#" + cid + "\").hide();\r\n" + "    jQuery(\"#" + eid + "\").show();\r\n" + "  });\r\n" + "});\r\n" + "</script>\r\n" + "\r\n" + "");
                }
                this.end();
                this.end();
            }
            this.end();
        }
        this.end();
    }

    private void createExpandIcon(Interceptor i, String id) {
        ((Html)this.div()).style("float:right;");
        ((Html)((Html)((Html)((Html)this.span()).id("e" + id)).classAttr("ui-icon ui-icon-triangle-1-w")).title("expand")).end();
        this.end();
        ((Html)this.div()).style("float:right;");
        ((Html)((Html)((Html)((Html)this.span()).id("c" + id)).classAttr("ui-icon ui-icon-triangle-1-s")).title("collapse")).end();
        this.end();
    }

    private void createHelpIcon(Interceptor i, String id) {
        String helpId = i.getHelpId();
        if (helpId != null) {
            ((Html)this.div()).style("float:right;");
            ((Html)this.a()).href("http://membrane-soa.org/service-proxy-doc/" + this.getVersion() + "/configuration/reference/" + helpId + ".htm");
            ((Html)((Html)((Html)this.span()).classAttr("ui-icon ui-icon-help")).title("help")).end();
            this.end();
            this.end();
        }
    }

    private void createShowIconsScript(String did, String iid) {
        this.script();
        this.raw("jQuery(document).ready(function() {\r\n  jQuery(\"#" + iid + "\").hide();\r\n" + "  jQuery(\"#" + did + "\").hover(function()\r\n" + "  {\r\n" + "    jQuery(\"#" + iid + "\").show();\r\n" + "  }, function()\r\n" + "  {\r\n" + "    jQuery(\"#" + iid + "\").hide();\r\n" + "  });\r\n" + "});\r\n" + "");
        this.end();
    }

    private String getVersion() {
        String v = Constants.VERSION;
        int p = v.indexOf(46);
        if (p == -1) {
            return "current";
        }
        if ((p = v.indexOf(46, p + 1)) == -1) {
            return "current";
        }
        return v.substring(0, p);
    }

    private void createListenerRow(AbstractServiceProxy proxy) {
        this.tr();
        ((Html)((Html)this.td()).style("padding:0px;")).colspan("2");
        ((Html)this.div()).style("border: 1px solid black; padding:8px 5px; margin: 0px 10px; overflow-x: auto; background: #73b9d7;width: 630px;");
        ((Html)this.div()).classAttr("name");
        this.b();
        this.text("Listener");
        this.end();
        this.end();
        ((Html)this.div()).style("padding-top: 4px;");
        this.text("Virtual Host: " + proxy.getKey().getHost());
        this.br();
        if (proxy.getKey().getPort() != -1) {
            this.text("Port: " + proxy.getKey().getPort());
            this.br();
        }
        this.text("Path: " + proxy.getKey().getPath());
        this.br();
        this.text("Method: " + proxy.getKey().getMethod());
        if (proxy.getSslInboundContext() != null) {
            this.br();
            this.text("SSL: yes");
        }
        this.end();
        this.end();
        this.end();
        this.end();
    }

    public void createServiceProxyVisualization(AbstractServiceProxy proxy, String relativeRootPath) {
        ArrayList<Interceptor> leftStack = new ArrayList<Interceptor>();
        ArrayList<Interceptor> rightStack = new ArrayList<Interceptor>();
        ArrayList<Interceptor> list = new ArrayList<Interceptor>(proxy.getInterceptors());
        list.add(new AbstractInterceptor(){

            @Override
            public EnumSet<Interceptor.Flow> getFlow() {
                return Interceptor.Flow.Set.REQUEST_RESPONSE;
            }
        });
        for (Interceptor i : list) {
            EnumSet<Interceptor.Flow> f = i.getFlow();
            if (i instanceof ResponseInterceptor) {
                for (Interceptor i2 : ((ResponseInterceptor)i).getInterceptors()) {
                    rightStack.add(i2);
                }
                continue;
            }
            if (i instanceof RequestInterceptor) {
                for (Interceptor i3 : ((RequestInterceptor)i).getInterceptors()) {
                    leftStack.add(i3);
                }
                continue;
            }
            if (f.contains((Object)Interceptor.Flow.REQUEST)) {
                if (f.contains((Object)Interceptor.Flow.RESPONSE)) {
                    while (leftStack.size() < rightStack.size()) {
                        leftStack.add(null);
                    }
                    while (rightStack.size() < leftStack.size()) {
                        rightStack.add(null);
                    }
                    leftStack.add(i);
                    rightStack.add(i);
                    continue;
                }
                leftStack.add(i);
                continue;
            }
            if (!f.contains((Object)Interceptor.Flow.RESPONSE)) continue;
            rightStack.add(i);
        }
        boolean noTarget = proxy.getTargetURL() == null && proxy.getTargetHost() == null;
        ((Html)((Html)((Html)((Html)this.table()).cellspacing("0px")).cellpadding("0px")).classAttr("spv")).style("width:662px");
        this.createListenerRow(proxy);
        if (leftStack.size() > 1 || !noTarget) {
            this.createBeginArrowsRow();
            for (int i = 0; i < leftStack.size() - 1 - (noTarget ? 1 : 0); ++i) {
                ((Html)this.tr()).style("background:url(\"" + relativeRootPath + "/admin/images/spv-middle.png\");background-repeat:repeat-y;display:inline-table");
                this.createInterceptorRow(leftStack, rightStack, i, false);
                this.end();
            }
            this.createEndArrowsRow();
            if (noTarget) {
                this.tr();
                this.createInterceptorRow(leftStack, rightStack, leftStack.size() - 2, true);
                this.end();
            } else {
                this.createTargetRow(proxy);
            }
        }
        this.end();
    }

    private void createInterceptorRow(List<Interceptor> leftStack, List<Interceptor> rightStack, int i, boolean noMarginTop) {
        if (leftStack.get(i) == rightStack.get(i)) {
            this.createInterceptorVisualization(leftStack.get(i), 2, "spv_l" + i, noMarginTop);
        } else {
            this.createInterceptorVisualization(leftStack.get(i), 1, "spv_l" + i, noMarginTop);
            this.createInterceptorVisualization(rightStack.get(i), 1, "spv_r" + i, noMarginTop);
        }
    }

    private void createBeginArrowsRow() {
        this.tr();
        ((Html)((Html)this.td()).style("padding:0px;background:url(\"" + this.relativeRootPath + "/admin/images/spv-top.png\");" + "background-repeat:repeat-y;height:14px;")).colspan("2");
        this.end();
        this.end();
    }

    private void createEndArrowsRow() {
        ((Html)this.tr()).style("background:url(\"" + this.relativeRootPath + "/admin/images/spv-bottom.png\");background-repeat:repeat-y;height:14px;");
        ((Html)((Html)this.td()).style("padding:0px;")).colspan("2");
        this.end();
        this.end();
    }

    private void createTargetRow(AbstractServiceProxy proxy) {
        this.tr();
        ((Html)((Html)this.td()).style("padding:0px;")).colspan("2");
        ((Html)this.div()).style("border: 1px solid black; padding:8px 5px; margin: 0px 10px; overflow-x: auto; background: #73b9d7;width: 630px;");
        ((Html)this.div()).classAttr("name");
        this.b();
        this.text("Target");
        this.end();
        this.end();
        ((Html)this.div()).style("padding-top: 4px;");
        if (proxy.getTargetURL() == null) {
            this.text("Host: " + proxy.getTargetHost());
            this.br();
            this.text("Port: " + proxy.getTargetPort());
        } else {
            this.text("URL: " + proxy.getTargetURL());
        }
        if (proxy.getSslOutboundContext() != null) {
            this.br();
            this.text("SSL: yes");
        }
        this.end();
        this.end();
        this.end();
        this.end();
    }

    protected void creatExchangeMetaTable(String id) throws UnsupportedEncodingException {
        ((Html)this.table()).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display", "id", id});
        this.thead();
        this.tr();
        this.createThs("Property", "Value");
        this.end();
        this.end();
        this.tbody();
        this.end();
        this.end();
    }

    protected void creatHeaderTable(String id) throws UnsupportedEncodingException {
        ((Html)this.table()).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display", "id", id});
        this.thead();
        this.tr();
        this.createThs("Header Field", "Value");
        this.end();
        this.end();
        this.tbody();
        this.end();
        this.end();
    }

    protected void createClientsStatisticsTable() throws UnsupportedEncodingException {
        ((Html)this.table()).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display", "id", "clients-table"});
        this.thead();
        this.tr();
        this.createThs("Client", "Exchanges", "Min ms", "Max ms", "Avg ms");
        this.end();
        this.end();
        this.tbody();
        this.end();
        this.end();
    }

    protected void createMessageStatisticsTable() throws UnsupportedEncodingException {
        ((Html)this.table()).attr(new String[]{"cellpadding", "0", "cellspacing", "0", "border", "0", "class", "display", "id", "message-stat-table"});
        this.thead();
        this.tr();
        this.createThs("Time", "Status Code", "Proxy", "Method", "Path", "Client", "Server", "Request Content-Type", "Request Content-Length", "Response Content-Type", "Response Content-Length", "Duration ms");
        this.end();
        this.end();
        this.tbody();
        this.end();
        this.end();
    }
}

