/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.acl;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.FixedStreamReader;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.acl.AccessControl;
import com.predic8.membrane.core.interceptor.acl.Resource;
import com.predic8.membrane.core.resolver.ResolverMap;
import java.io.IOException;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

@MCElement(name="accessControl")
public class AccessControlInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)AccessControlInterceptor.class.getName());
    private String file;
    private AccessControl accessControl;

    public AccessControlInterceptor() {
        this.setDisplayName("Access Control");
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        Resource resource;
        try {
            resource = this.accessControl.getResourceFor(exc.getOriginalRequestUri());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            this.setResponseToAccessDenied(exc);
            return Outcome.ABORT;
        }
        if (!resource.checkAccess(exc.getRemoteAddr(), exc.getRemoteAddrIp())) {
            this.setResponseToAccessDenied(exc);
            return Outcome.ABORT;
        }
        return Outcome.CONTINUE;
    }

    private void setResponseToAccessDenied(Exchange exc) throws IOException {
        exc.setResponse(Response.forbidden("Access denied: you are not authorized to access this service.").build());
    }

    @Required
    @MCAttribute
    public void setFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    @Override
    public void init() throws Exception {
        this.accessControl = this.parse(this.file, this.router);
    }

    public AccessControl getAccessControl() {
        return this.accessControl;
    }

    protected AccessControl parse(String fileName, Router router) throws Exception {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            FixedStreamReader reader = new FixedStreamReader(factory.createXMLStreamReader(router.getResolverMap().resolve(ResolverMap.combine(router == null ? null : router.getBaseLocation(), fileName))));
            AccessControl res = (AccessControl)new AccessControl(router).parse(reader);
            res.init(router);
            return res;
        }
        catch (Exception e) {
            log.error("Error initializing accessControl.", (Throwable)e);
            System.err.println("Error initializing accessControl: terminating.");
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getShortDescription() {
        return "Authenticates incoming requests based on the file " + StringEscapeUtils.escapeHtml((String)this.file) + " .";
    }
}

