/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.acl;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.interceptor.acl.Resource;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamReader;

public class AccessControl
extends AbstractXmlElement {
    public static final String ELEMENT_NAME = "accessControl";
    private Router router;
    private List<Resource> resources = new ArrayList<Resource>();

    public AccessControl(Router router) {
        this.router = router;
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected void parseChildren(XMLStreamReader token, String child) throws Exception {
        if ("resource".equals(child)) {
            this.resources.add((Resource)new Resource(this.router).parse(token));
        }
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public Resource getResourceFor(String uri) throws Exception {
        if (uri == null) {
            throw new IllegalArgumentException("Resource URI can not be null.");
        }
        for (Resource res : this.resources) {
            if (!res.matches(uri)) continue;
            return res;
        }
        throw new IllegalArgumentException("Resource not found for given path");
    }

    public void init(Router router) {
        for (Resource resource : this.resources) {
            resource.init(router);
        }
    }
}

