/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.rules.AbstractServiceProxy;
import com.predic8.membrane.core.rules.NullRule;
import com.predic8.membrane.core.rules.ProxyRule;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.transport.http.AbstractHttpHandler;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="ruleMatching")
public class RuleMatchingInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)RuleMatchingInterceptor.class.getName());
    private boolean xForwardedForEnabled = true;
    private int maxXForwardedForHeaders = 20;

    public RuleMatchingInterceptor() {
        this.name = "Rule Matching Interceptor";
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (exc.getRule() != null) {
            return Outcome.CONTINUE;
        }
        Rule rule = this.getRule(exc);
        exc.setRule(rule);
        if (exc.getRule().getSslOutboundContext() != null) {
            exc.setProperty("SSL_CONTEXT", exc.getRule().getSslOutboundContext());
        }
        if (rule instanceof NullRule) {
            this.handleNoRuleFound(exc);
            return Outcome.ABORT;
        }
        if (this.xForwardedForEnabled && rule instanceof AbstractServiceProxy) {
            this.insertXForwardedFor(exc);
        }
        return Outcome.CONTINUE;
    }

    private void handleNoRuleFound(Exchange exc) throws IOException {
        exc.setResponse(Response.badRequest("This request was not accepted by <a href=\"http://www.membrane-soa.org/service-proxy-doc/\">Membrane Service Proxy</a>. Please correct the request and try again.", false).build());
    }

    private Rule getRule(Exchange exc) {
        Request request = exc.getRequest();
        AbstractHttpHandler handler = exc.getHandler();
        String hostHeader = request.getHeader().getHost();
        String method = request.getMethod();
        String uri = request.getUri();
        String version = request.getVersion();
        int port = handler.isMatchLocalPort() ? handler.getLocalPort() : -1;
        String localIP = handler.getLocalAddress().getHostAddress();
        Rule rule = this.router.getRuleManager().getMatchingRule(hostHeader, method, uri, version, port, localIP);
        if (rule != null) {
            if (log.isDebugEnabled()) {
                log.debug("Matching Rule found for RuleKey " + hostHeader + " " + method + " " + uri + " " + port + " " + localIP);
            }
            return rule;
        }
        return this.findProxyRule(exc);
    }

    private Rule findProxyRule(Exchange exc) {
        for (Rule rule : this.router.getRuleManager().getRules()) {
            if (!(rule instanceof ProxyRule) || rule.getKey().getIp() != null && !rule.getKey().getIp().equals(exc.getHandler().getLocalAddress().toString()) || rule.getKey().getPort() != -1 && exc.getHandler().getLocalPort() != -1 && rule.getKey().getPort() != exc.getHandler().getLocalPort()) continue;
            if (log.isDebugEnabled()) {
                log.debug("proxy rule found: " + rule);
            }
            return rule;
        }
        log.debug("No rule found for incoming request");
        return new NullRule();
    }

    private void insertXForwardedFor(AbstractExchange exc) {
        Header h = exc.getRequest().getHeader();
        if (h.getNumberOf("X-Forwarded-For") > this.maxXForwardedForHeaders) {
            Request r = exc.getRequest();
            throw new RuntimeException("Request caused X-Forwarded-For flood: " + r.getStartLine() + r.getHeader().toString());
        }
        h.setXForwardedFor(this.getXForwardedForHeaderValue(exc));
        if (h.getNumberOf("X-Forwarded-Proto") > this.maxXForwardedForHeaders) {
            Request r = exc.getRequest();
            throw new RuntimeException("Request caused X-Forwarded-Proto flood: " + r.getStartLine() + r.getHeader().toString());
        }
        h.setXForwardedProto(this.getXForwardedProtoHeaderValue(exc));
    }

    private String getXForwardedForHeaderValue(AbstractExchange exc) {
        if (this.getXForwardedFor(exc) != null) {
            return this.getXForwardedFor(exc) + ", " + exc.getRemoteAddrIp();
        }
        return exc.getRemoteAddrIp();
    }

    private String getXForwardedProtoHeaderValue(AbstractExchange exc) {
        String proto;
        String string = proto = ((Exchange)exc).getRule().getSslInboundContext() != null ? "https" : "http";
        if (this.getXForwardedProto(exc) != null) {
            return this.getXForwardedProto(exc);
        }
        return proto;
    }

    private String getXForwardedFor(AbstractExchange exc) {
        return exc.getRequest().getHeader().getXForwardedFor();
    }

    private String getXForwardedProto(AbstractExchange exc) {
        return exc.getRequest().getHeader().getXForwardedProto();
    }

    public String toString() {
        return "RuleMatchingInterceptor";
    }

    public boolean isxForwardedForEnabled() {
        return this.xForwardedForEnabled;
    }

    @MCAttribute
    public void setxForwardedForEnabled(boolean xForwardedForEnabled) {
        this.xForwardedForEnabled = xForwardedForEnabled;
    }

    public int getMaxXForwardedForHeaders() {
        return this.maxXForwardedForHeaders;
    }

    @MCAttribute
    public void setMaxXForwardedForHeaders(int maxXForwardedForHeaders) {
        this.maxXForwardedForHeaders = maxXForwardedForHeaders;
    }
}

