/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.rules.ProxyRule;
import com.predic8.membrane.core.ws.relocator.Relocator;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelocatingInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)RelocatingInterceptor.class.getName());
    protected String host;
    protected String protocol;
    protected String port;
    protected Relocator.PathRewriter pathRewriter;

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        if (exc.getRule() instanceof ProxyRule) {
            log.debug(this.name + " ProxyRule found: No relocating done!");
            return Outcome.CONTINUE;
        }
        if (!this.wasGetRequest(exc)) {
            log.debug(this.name + " HTTP method wasn't GET: No relocating done!");
            return Outcome.CONTINUE;
        }
        if (!this.hasContent(exc)) {
            log.debug(this.name + " No Content: No relocating done!");
            return Outcome.CONTINUE;
        }
        if (!exc.getResponse().isXML()) {
            log.debug(this.name + " Body contains no XML: No relocating done!");
            return Outcome.CONTINUE;
        }
        try {
            this.rewrite(exc);
        }
        catch (XMLStreamException e) {
            throw new Exception("while rewriting " + exc.getRequestURI(), e);
        }
        return Outcome.CONTINUE;
    }

    abstract void rewrite(Exchange var1) throws Exception;

    private boolean hasContent(Exchange exc) {
        return exc.getResponse().getHeader().getContentType() != null;
    }

    private boolean wasGetRequest(Exchange exc) {
        return "GET".equals(exc.getRequest().getMethod());
    }

    protected int getLocationPort(Exchange exc) {
        if ("".equals(this.port)) {
            return -1;
        }
        if (this.port != null) {
            return Integer.parseInt(this.port);
        }
        return exc.getHandler().getLocalPort();
    }

    protected String getLocationHost(Exchange exc) {
        if (this.host != null) {
            return this.host;
        }
        String locHost = exc.getOriginalHostHeaderHost();
        log.debug("host " + locHost);
        if (locHost == null) {
            return "localhost";
        }
        return locHost;
    }

    protected String getLocationProtocol() {
        if (this.protocol != null) {
            return this.protocol;
        }
        return "http";
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        log.debug("host property set for" + this.name + ":" + host);
        this.host = host;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        log.debug("protocol property set for " + this.name + ":" + protocol);
        this.protocol = protocol;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public Relocator.PathRewriter getPathRewriter() {
        return this.pathRewriter;
    }

    public void setPathRewriter(Relocator.PathRewriter pathRewriter) {
        this.pathRewriter = pathRewriter;
    }
}

