/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="httpClient")
public class HTTPClientInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)HTTPClientInterceptor.class.getName());
    private boolean failOverOn5XX;
    private boolean adjustHostHeader = true;
    private HttpClientConfiguration httpClientConfig;
    private HttpClient hc;

    public HTTPClientInterceptor() {
        this.name = "HTTPClient";
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        exc.blockRequestIfNeeded();
        try {
            this.hc.call(exc, this.adjustHostHeader, this.failOverOn5XX);
            return Outcome.RETURN;
        }
        catch (ConnectException e) {
            exc.setResponse(Response.badGateway("Target " + this.getDestination(exc) + " is not reachable.").build());
            log.warn("Target " + this.getDestination(exc) + " is not reachable. " + e);
            return Outcome.ABORT;
        }
        catch (UnknownHostException e) {
            exc.setResponse(Response.internalServerError("Target host " + this.getDestination(exc) + " is unknown. DNS was unable to resolve host name.").build());
            return Outcome.ABORT;
        }
    }

    private String getDestination(Exchange exc) {
        return exc.getDestinations().get(0);
    }

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
        this.hc = this.httpClientConfig == null ? router.getResolverMap().getHTTPSchemaResolver().getHttpClient() : new HttpClient(this.httpClientConfig);
        this.hc.setStreamPumpStats(this.getRouter().getStatistics().getStreamPumpStats());
    }

    public boolean isFailOverOn5XX() {
        return this.failOverOn5XX;
    }

    @MCAttribute
    public void setFailOverOn5XX(boolean failOverOn5XX) {
        this.failOverOn5XX = failOverOn5XX;
    }

    public boolean isAdjustHostHeader() {
        return this.adjustHostHeader;
    }

    @MCAttribute
    public void setAdjustHostHeader(boolean adjustHostHeader) {
        this.adjustHostHeader = adjustHostHeader;
    }

    public HttpClientConfiguration getHttpClientConfig() {
        return this.httpClientConfig;
    }

    @MCChildElement
    public void setHttpClientConfig(HttpClientConfiguration httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }
}

