/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchangestore.ExchangeStore;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.administration.AdminConsoleInterceptor;
import com.predic8.membrane.core.rules.AbstractServiceProxy;
import com.predic8.membrane.core.rules.Rule;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@MCElement(name="exchangeStore")
public class ExchangeStoreInterceptor
extends AbstractInterceptor
implements ApplicationContextAware {
    private static final String BEAN_ID_ATTRIBUTE_CANNOT_BE_USED = "bean id attribute cannot be used";
    private ApplicationContext applicationContext;
    private ExchangeStore store;
    private String exchangeStoreBeanId;
    private Set<AbstractServiceProxy> serviceProxiesContainingAdminConsole = new HashSet<AbstractServiceProxy>();

    public ExchangeStoreInterceptor() {
        this.name = "  Store Interceptor";
    }

    public ExchangeStoreInterceptor(ExchangeStore exchangeStore) {
        this();
        this.setExchangeStore(exchangeStore);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        return this.handle(exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        return this.handle(exc, Interceptor.Flow.RESPONSE);
    }

    @Override
    public void handleAbort(Exchange exc) {
        this.handle(exc, Interceptor.Flow.ABORT);
    }

    protected Outcome handle(Exchange exc, Interceptor.Flow flow) {
        if (this.serviceProxiesContainingAdminConsole.contains(exc.getRule())) {
            return Outcome.CONTINUE;
        }
        this.store.snap(exc, flow);
        return Outcome.CONTINUE;
    }

    public ExchangeStore getExchangeStore() {
        return this.store;
    }

    @MCAttribute(attributeName="name")
    public void setExchangeStore(ExchangeStore exchangeStore) {
        this.store = exchangeStore;
        this.exchangeStoreBeanId = BEAN_ID_ATTRIBUTE_CANNOT_BE_USED;
    }

    public String getExchangeStoreBeanId() {
        return this.exchangeStoreBeanId;
    }

    @Deprecated
    public void setExchangeStoreBeanId(String exchangeStoreBeanId) {
        this.exchangeStoreBeanId = exchangeStoreBeanId;
    }

    @Override
    public void init() throws Exception {
        if (this.exchangeStoreBeanId != BEAN_ID_ATTRIBUTE_CANNOT_BE_USED) {
            this.store = this.exchangeStoreBeanId != null ? (ExchangeStore)this.applicationContext.getBean(this.exchangeStoreBeanId, ExchangeStore.class) : this.router.getExchangeStore();
        }
        this.searchAdminConsole();
    }

    private void searchAdminConsole() {
        for (Rule r : this.router.getRuleManager().getRules()) {
            if (!(r instanceof AbstractServiceProxy)) continue;
            for (Interceptor i : r.getInterceptors()) {
                if (!(i instanceof AdminConsoleInterceptor)) continue;
                this.serviceProxiesContainingAdminConsole.add((AbstractServiceProxy)r);
            }
        }
    }

    @Override
    public String getShortDescription() {
        return "Logs all exchanges (requests and responses) into an exchange store that can be inspected using <a href=\"http://www.membrane-soa.org/soap-monitor/\">Membrane Monitor</a>.";
    }
}

