/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http.xml;

import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.http.xml.Component;
import com.predic8.membrane.core.http.xml.Host;
import com.predic8.membrane.core.http.xml.Param;
import com.predic8.membrane.core.http.xml.Path;
import com.predic8.membrane.core.http.xml.Port;
import com.predic8.membrane.core.http.xml.Query;
import com.predic8.membrane.core.util.URLParamUtil;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class URI
extends AbstractXmlElement {
    public static final String ELEMENT_NAME = "uri";
    String value;
    Port port;
    Host host;
    Path path;
    Query query;

    public URI() {
    }

    public URI(String uri) throws Exception {
        this.setValue(uri);
    }

    @Override
    protected void parseAttributes(XMLStreamReader token) throws XMLStreamException {
        this.value = token.getAttributeValue("", "value");
    }

    @Override
    protected void parseChildren(XMLStreamReader token, String child) throws Exception {
        if ("port".equals(child)) {
            this.port = (Port)new Port().parse(token);
        } else if ("host".equals(child)) {
            this.host = (Host)new Host().parse(token);
        } else if ("path".equals(child)) {
            this.path = (Path)new Path().parse(token);
        } else if ("query".equals(child)) {
            this.query = (Query)new Query().parse(token);
        }
    }

    @Override
    public void write(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(ELEMENT_NAME);
        out.writeAttribute("value", this.value);
        this.writeIfNotNull(this.host, out);
        this.writeIfNotNull(this.port, out);
        this.writeIfNotNull(this.path, out);
        this.writeIfNotNull(this.query, out);
        out.writeEndElement();
    }

    public void setValue(String value) throws Exception {
        this.value = value;
        java.net.URI jUri = new java.net.URI(value);
        if (jUri.getHost() != null) {
            this.setHost(jUri.getHost());
        }
        if (jUri.getPort() != -1) {
            this.setPort(jUri.getPort());
        }
        this.parsePathFromURI(jUri);
        this.parseQueryFromURI(jUri);
    }

    private void parseQueryFromURI(java.net.URI jUri) throws UnsupportedEncodingException {
        if (jUri.getQuery() == null) {
            return;
        }
        Query q = new Query();
        for (Map.Entry<String, String> e : URLParamUtil.parseQueryString(jUri.getQuery()).entrySet()) {
            q.getParams().add(new Param(e.getKey(), e.getValue()));
        }
        this.setQuery(q);
    }

    private void parsePathFromURI(java.net.URI jUri) {
        if (jUri.getPath() == null) {
            return;
        }
        Path p = new Path();
        for (String c : jUri.getPath().substring(1).split("/")) {
            p.getComponents().add(new Component(c));
        }
        this.setPath(p);
    }

    public int getPort() {
        return this.port.getValue();
    }

    public void setPort(int port) {
        this.port = new Port(port);
    }

    public String getHost() {
        return this.host.getValue();
    }

    public void setHost(String host) {
        this.host = new Host(host);
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public String getValue() {
        return this.value;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }
}

