/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.Body;
import com.predic8.membrane.core.http.ChunkedBody;
import com.predic8.membrane.core.http.ChunkedBodyTransferrer;
import com.predic8.membrane.core.http.EmptyBody;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.MessageObserver;
import com.predic8.membrane.core.http.PlainBodyTransferrer;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.predic8.membrane.core.util.MessageUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message {
    private static Logger log = LoggerFactory.getLogger((String)Message.class.getName());
    protected Header header = new Header();
    protected AbstractBody body = new EmptyBody();
    protected String version = "1.1";
    private boolean released = false;
    private String errorMessage = "";
    private static XOPReconstitutor xopr = new XOPReconstitutor();

    public void read(InputStream in, boolean createBody) throws IOException, EndOfStreamException {
        this.parseStartLine(in);
        this.header = new Header(in);
        if (createBody) {
            this.createBody(in);
        }
    }

    public void readBody() throws IOException {
        this.body.read();
    }

    public AbstractBody getBody() {
        return this.body;
    }

    public InputStream getBodyAsStream() {
        try {
            return this.body.getContentAsStream();
        }
        catch (IOException e) {
            log.error("Could not get body as stream", (Throwable)e);
            throw new RuntimeException("Could not get body as stream", e);
        }
    }

    public InputStream getBodyAsStreamDecoded() {
        try {
            Message m = xopr.getReconstitutedMessage(this);
            if (m != null) {
                return m.getBodyAsStream();
            }
            return MessageUtil.getContentAsStream(this);
        }
        catch (Exception e) {
            log.error("Could not decode body stream", (Throwable)e);
            throw new RuntimeException("Could not decode body stream", e);
        }
    }

    public String getBodyAsStringDecoded() {
        try {
            return new String(MessageUtil.getContent(this), this.getCharset());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setBody(AbstractBody b) {
        this.body = b;
    }

    public void setBodyContent(byte[] content) {
        this.body = new Body(content);
        this.header.removeFields("Content-Encoding");
        this.header.removeFields("Transfer-Encoding");
        this.header.setContentLength(content.length);
    }

    protected void createBody(InputStream in) throws IOException {
        log.debug("createBody");
        if (this.isHTTP10()) {
            this.body = new Body(in, this.header.getContentLength());
            return;
        }
        if (this.header.isChunked()) {
            this.body = new ChunkedBody(in);
            return;
        }
        if (!this.isKeepAlive() || this.header.hasContentLength() || this.header.isProxyConnectionClose()) {
            this.body = new Body(in, this.header.getContentLength());
            return;
        }
        if (log.isDebugEnabled()) {
            log.error("Message has no content length: " + this.toString());
        }
        if (this instanceof Request && ((Request)this).isOPTIONSRequest()) {
            this.body = new EmptyBody();
            return;
        }
        this.body = new Body(in);
    }

    protected abstract void parseStartLine(InputStream var1) throws IOException, EndOfStreamException;

    public Header getHeader() {
        return this.header;
    }

    public synchronized void release() {
        this.notify();
        this.released = true;
    }

    public boolean hasMsgReleased() {
        return this.released;
    }

    public void setHeader(Header srcHeader) {
        this.header = srcHeader;
    }

    public final void write(OutputStream out) throws IOException {
        this.writeStartLine(out);
        this.header.write(out);
        out.write(Constants.CRLF_BYTES);
        if (this.header.is100ContinueExpected()) {
            out.flush();
            return;
        }
        this.body.write(this.getHeader().isChunked() ? new ChunkedBodyTransferrer(out) : new PlainBodyTransferrer(out));
        out.flush();
    }

    public void writeStartLine(OutputStream out) throws IOException {
        out.write(this.getStartLine().getBytes(Constants.ISO_8859_1_CHARSET));
    }

    public abstract String getStartLine();

    public boolean isHTTP11() {
        return this.version.equalsIgnoreCase("1.1");
    }

    public boolean isHTTP10() {
        return this.version.equalsIgnoreCase("1.0");
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.getStartLine() + this.header.toString() + "\r\n" + this.body.toString();
    }

    public boolean isKeepAlive() {
        if (this.isHTTP10()) {
            return false;
        }
        if (this.header.getConnection() == null) {
            return true;
        }
        if (this.header.isConnectionClose()) {
            return false;
        }
        return !this.header.isProxyConnectionClose();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getName() {
        return "message";
    }

    public boolean isBodyEmpty() throws IOException {
        if (this.header.hasContentLength()) {
            return this.header.getContentLength() == 0;
        }
        if (this.getBody().read) {
            return this.getBody().getLength() == 0;
        }
        return false;
    }

    public boolean isImage() {
        if (this.header.getContentType() == null) {
            return false;
        }
        return this.header.getContentType().indexOf("image") >= 0;
    }

    public boolean isXML() {
        if (this.header.getContentType() == null) {
            return false;
        }
        return this.header.getContentType().toLowerCase().indexOf("xml") > 0;
    }

    public boolean isJSON() {
        if (this.header.getContentType() == null) {
            return false;
        }
        return this.header.getContentType().indexOf("json") > 0;
    }

    public boolean isHTML() {
        if (this.header.getContentType() == null) {
            return false;
        }
        return this.header.getContentType().indexOf("html") > 0;
    }

    public boolean isCSS() {
        if (this.header.getContentType() == null) {
            return false;
        }
        return this.header.getContentType().indexOf("css") > 0;
    }

    public boolean isJavaScript() {
        if (this.header.getContentType() == null) {
            return false;
        }
        return this.header.getContentType().indexOf("javascript") > 0;
    }

    public boolean isGzip() {
        return "gzip".equalsIgnoreCase(this.header.getContentEncoding());
    }

    public boolean isDeflate() {
        return "deflate".equalsIgnoreCase(this.header.getContentEncoding());
    }

    public String getCharset() {
        return this.header.getCharset();
    }

    public void addObserver(MessageObserver observer) {
        this.body.addObserver(observer);
    }

    public int estimateHeapSize() {
        try {
            return 100 + (this.header != null ? this.header.estimateHeapSize() : 0) + (this.body != null ? (this.body.isRead() ? this.body.getLength() : 0) : 0) + (this.errorMessage != null ? 2 * this.errorMessage.length() : 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

