/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.AbstractBodyTransferrer;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.util.ByteUtil;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Body
extends AbstractBody {
    private static final int BUFFER_SIZE;
    private static Logger log;
    private final InputStream inputStream;
    private final int length;

    public Body(InputStream in) throws IOException {
        this(in, -1);
    }

    public Body(InputStream in, int length) throws IOException {
        this.inputStream = in;
        this.length = length;
    }

    public Body(byte[] content) {
        this.inputStream = null;
        this.length = content.length;
        this.chunks.clear();
        this.chunks.add(new Chunk(content));
        this.markAsRead();
    }

    @Override
    protected void readLocal() throws IOException {
        this.chunks.add(new Chunk(ByteUtil.readByteArray(this.inputStream, this.length)));
    }

    @Override
    protected void writeAlreadyRead(AbstractBodyTransferrer out) throws IOException {
        if (this.getLength() == 0) {
            return;
        }
        out.write(this.getContent(), 0, this.getLength());
        out.finish();
    }

    @Override
    protected void writeNotRead(AbstractBodyTransferrer out) throws IOException {
        byte[] buffer = new byte[BUFFER_SIZE];
        int length = 0;
        this.chunks.clear();
        for (int totalLength = 0; (this.length > totalLength || this.length == -1) && (length = this.inputStream.read(buffer)) > 0; totalLength += length) {
            out.write(buffer, 0, length);
            byte[] chunk = new byte[length];
            System.arraycopy(buffer, 0, chunk, 0, length);
            this.chunks.add(new Chunk(chunk));
        }
        out.finish();
        this.markAsRead();
    }

    @Override
    protected void writeStreamed(AbstractBodyTransferrer out) throws IOException {
        byte[] buffer = new byte[BUFFER_SIZE];
        int length = 0;
        this.chunks.clear();
        for (int totalLength = 0; (this.length > totalLength || this.length == -1) && (length = this.inputStream.read(buffer)) > 0; totalLength += length) {
            out.write(buffer, 0, length);
        }
        out.finish();
    }

    @Override
    protected byte[] getRawLocal() throws IOException {
        if (this.chunks.isEmpty()) {
            log.debug("size of chunks list: " + this.chunks.size() + "  " + this.hashCode());
            log.debug("chunks size is: " + this.chunks.size() + " at time: " + System.currentTimeMillis());
            return new byte[0];
        }
        return this.getContent();
    }

    static {
        String bufferSize = System.getProperty("membrane.core.http.body.buffersize");
        BUFFER_SIZE = bufferSize == null ? 8192 : Integer.parseInt(bufferSize);
        log = LoggerFactory.getLogger((String)Body.class.getName());
    }
}

