/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.http.AbstractBodyTransferrer;
import com.predic8.membrane.core.http.BodyInputStream;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.http.MessageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBody {
    private static final Logger log = LoggerFactory.getLogger((String)AbstractBody.class.getName());
    boolean read;
    protected List<Chunk> chunks = new ArrayList<Chunk>();
    protected List<MessageObserver> observers = new ArrayList<MessageObserver>(1);

    public void read() throws IOException {
        if (this.read) {
            return;
        }
        for (MessageObserver observer : this.observers) {
            observer.bodyRequested(this);
        }
        this.chunks.clear();
        this.readLocal();
        this.markAsRead();
    }

    protected void markAsRead() {
        if (this.read) {
            return;
        }
        this.read = true;
        for (MessageObserver observer : this.observers) {
            observer.bodyComplete(this);
        }
        this.observers.clear();
    }

    protected abstract void readLocal() throws IOException;

    public byte[] getContent() throws IOException {
        this.read();
        byte[] content = new byte[this.getLength()];
        int destPos = 0;
        for (Chunk chunk : this.chunks) {
            destPos = chunk.copyChunk(content, destPos);
        }
        return content;
    }

    public InputStream getContentAsStream() throws IOException {
        this.read();
        return new BodyInputStream(this.chunks);
    }

    public void write(AbstractBodyTransferrer out) throws IOException {
        if (!this.read) {
            MessageObserver obs;
            boolean relevantObservers = true;
            if (this.observers.size() == 1 && (obs = this.observers.get(0)).getClass().getName().contains("Response$ResponseBuilder")) {
                relevantObservers = false;
                this.writeStreamed(out);
            }
            if (relevantObservers) {
                for (MessageObserver observer : this.observers) {
                    observer.bodyRequested(this);
                }
                this.writeNotRead(out);
            }
            return;
        }
        this.writeAlreadyRead(out);
    }

    protected abstract void writeAlreadyRead(AbstractBodyTransferrer var1) throws IOException;

    protected abstract void writeNotRead(AbstractBodyTransferrer var1) throws IOException;

    protected abstract void writeStreamed(AbstractBodyTransferrer var1) throws IOException;

    public int getLength() throws IOException {
        this.read();
        int length = 0;
        for (Chunk chunk : this.chunks) {
            length += chunk.getLength();
        }
        return length;
    }

    public byte[] getRaw() throws IOException {
        this.read();
        return this.getRawLocal();
    }

    protected abstract byte[] getRawLocal() throws IOException;

    public String toString() {
        if (this.chunks.isEmpty()) {
            return "";
        }
        try {
            return new String(this.getRaw(), Constants.UTF_8_CHARSET);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return "Error in body: " + e;
        }
    }

    public boolean isRead() {
        return this.read;
    }

    void addObserver(MessageObserver observer) {
        if (this.read) {
            observer.bodyComplete(this);
            return;
        }
        this.observers.add(observer);
    }

    List<MessageObserver> getObservers() {
        return this.observers;
    }
}

