/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchangestore;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchangestore.AbstractExchangeStore;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.model.IExchangesStoreListener;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.RuleKey;
import com.predic8.membrane.core.rules.StatisticCollector;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

@MCElement(name="memoryExchangeStore")
public class MemoryExchangeStore
extends AbstractExchangeStore {
    private Map<RuleKey, List<AbstractExchange>> exchangesMap = new HashMap<RuleKey, List<AbstractExchange>>();
    private List<AbstractExchange> totals = new Vector<AbstractExchange>();

    @Override
    public void snap(AbstractExchange exc, Interceptor.Flow flow) {
        if (flow != Interceptor.Flow.REQUEST) {
            return;
        }
        if (this.isKeyInStore(exc)) {
            this.getKeyList(exc).add(exc);
        } else {
            Vector<AbstractExchange> list = new Vector<AbstractExchange>();
            list.add(exc);
            this.exchangesMap.put(exc.getRule().getKey(), list);
        }
        this.totals.add(exc);
        for (IExchangesStoreListener listener : this.exchangesStoreListeners) {
            exc.addExchangeStoreListener(listener);
            listener.addExchange(exc.getRule(), exc);
        }
    }

    @Override
    public void remove(AbstractExchange exc) {
        this.removeWithoutNotify(exc);
        for (IExchangesStoreListener listener : this.exchangesStoreListeners) {
            listener.removeExchange(exc);
        }
    }

    @Override
    public void removeAllExchanges(Rule rule) {
        AbstractExchange[] exchanges = this.getExchanges(rule.getKey());
        this.exchangesMap.remove(rule.getKey());
        this.totals.removeAll(Arrays.asList(exchanges));
        for (IExchangesStoreListener listener : this.exchangesStoreListeners) {
            listener.removeExchanges(rule, exchanges);
        }
    }

    @Override
    public AbstractExchange[] getExchanges(RuleKey ruleKey) {
        List<AbstractExchange> exchangesList = this.exchangesMap.get(ruleKey);
        if (exchangesList == null) {
            return new AbstractExchange[0];
        }
        return exchangesList.toArray(new AbstractExchange[exchangesList.size()]);
    }

    @Override
    public int getNumberOfExchanges(RuleKey ruleKey) {
        if (!this.exchangesMap.containsKey(ruleKey)) {
            return 0;
        }
        return this.exchangesMap.get(ruleKey).size();
    }

    @Override
    public StatisticCollector getStatistics(RuleKey key) {
        StatisticCollector statistics = new StatisticCollector(false);
        List<AbstractExchange> exchangesList = this.exchangesMap.get(key);
        if (exchangesList == null || exchangesList.isEmpty()) {
            return statistics;
        }
        for (int i = 0; i < exchangesList.size(); ++i) {
            statistics.collectFrom(exchangesList.get(i));
        }
        return statistics;
    }

    @Override
    public Object[] getAllExchanges() {
        if (this.totals.isEmpty()) {
            return null;
        }
        return this.totals.toArray();
    }

    @Override
    public List<AbstractExchange> getAllExchangesAsList() {
        return this.totals;
    }

    @Override
    public void removeAllExchanges(AbstractExchange[] exchanges) {
        for (AbstractExchange exc : exchanges) {
            this.removeWithoutNotify(exc);
        }
        for (IExchangesStoreListener listener : this.exchangesStoreListeners) {
            listener.removeExchanges(exchanges);
        }
    }

    private List<AbstractExchange> getKeyList(AbstractExchange exc) {
        return this.exchangesMap.get(exc.getRule().getKey());
    }

    private boolean isKeyInStore(AbstractExchange exc) {
        return this.exchangesMap.containsKey(exc.getRule().getKey());
    }

    private void removeWithoutNotify(AbstractExchange exc) {
        if (!this.isKeyInStore(exc)) {
            return;
        }
        this.getKeyList(exc).remove(exc);
        if (this.getKeyList(exc).isEmpty()) {
            this.exchangesMap.remove(exc.getRule().getKey());
        }
        this.totals.remove(exc);
        exc.informExchangeViewerOnRemoval();
    }
}

