/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchangestore;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchangestore.AbstractExchangeStore;
import com.predic8.membrane.core.exchangestore.ClientStatistics;
import com.predic8.membrane.core.exchangestore.ClientStatisticsCollector;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.MessageObserver;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.model.AbstractExchangeViewerListener;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.RuleKey;
import com.predic8.membrane.core.rules.StatisticCollector;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="limitedMemoryExchangeStore")
public class LimitedMemoryExchangeStore
extends AbstractExchangeStore {
    private static Logger log = LoggerFactory.getLogger(LimitedMemoryExchangeStore.class);
    private int maxSize = 1000000;
    private int currentSize;
    private final Queue<AbstractExchange> exchanges = new LinkedList<AbstractExchange>();
    private Map<AbstractExchange, Request> inflight = new ConcurrentHashMap<AbstractExchange, Request>();
    private long lastModification = System.currentTimeMillis();
    static final int additionalMemoryToAddInMb = 100;

    @Override
    public void snap(final AbstractExchange exc, final Interceptor.Flow flow) {
        exc.addExchangeViewerListener(new AbstractExchangeViewerListener(){

            @Override
            public void setExchangeFinished() {
                LimitedMemoryExchangeStore.this.inflight.remove(exc);
            }
        });
        if (flow == Interceptor.Flow.REQUEST) {
            exc.getRequest().addObserver(new MessageObserver(){

                @Override
                public void bodyRequested(AbstractBody body) {
                }

                @Override
                public void bodyComplete(AbstractBody body) {
                    AbstractBody b;
                    Response r = exc.getResponse();
                    if (r != null && (b = r.getBody()) != null && b.isRead()) {
                        return;
                    }
                    LimitedMemoryExchangeStore.this.inflight.put(exc, exc.getRequest());
                    LimitedMemoryExchangeStore.this.modify();
                }
            });
            return;
        }
        try {
            Response m = exc.getResponse();
            if (m != null) {
                m.addObserver(new MessageObserver(){

                    @Override
                    public void bodyRequested(AbstractBody body) {
                    }

                    @Override
                    public void bodyComplete(AbstractBody body) {
                        LimitedMemoryExchangeStore.this.snapInternal(exc, flow);
                        LimitedMemoryExchangeStore.this.inflight.remove(exc);
                        LimitedMemoryExchangeStore.this.modify();
                    }
                });
            } else {
                this.inflight.remove(exc);
                this.modify();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void snapInternal(AbstractExchange exc, Interceptor.Flow flow) {
        if (exc.getHeapSizeEstimation() > this.maxSize) {
            return;
        }
        this.makeSpaceIfNeeded(exc);
        this.exchanges.offer(exc);
        this.modify();
        this.currentSize += exc.getHeapSizeEstimation();
    }

    @Override
    public synchronized void remove(AbstractExchange exc) {
        this.exchanges.remove(exc);
        this.modify();
    }

    @Override
    public synchronized void removeAllExchanges(Rule rule) {
        this.exchanges.removeAll(this.getExchangeList(rule.getKey()));
        this.modify();
    }

    private synchronized List<AbstractExchange> getExchangeList(RuleKey key) {
        ArrayList<AbstractExchange> c = new ArrayList<AbstractExchange>();
        for (AbstractExchange exc : this.exchanges) {
            if (!exc.getRule().equals(key)) continue;
            c.add(exc);
        }
        return c;
    }

    @Override
    public synchronized AbstractExchange[] getExchanges(RuleKey ruleKey) {
        return this.getExchangeList(ruleKey).toArray(new AbstractExchange[0]);
    }

    @Override
    public synchronized int getNumberOfExchanges(RuleKey ruleKey) {
        return this.getExchangeList(ruleKey).size();
    }

    @Override
    public synchronized StatisticCollector getStatistics(RuleKey key) {
        StatisticCollector statistics = new StatisticCollector(false);
        List<AbstractExchange> exchangesList = this.getExchangeList(key);
        if (exchangesList == null || exchangesList.isEmpty()) {
            return statistics;
        }
        for (int i = 0; i < exchangesList.size(); ++i) {
            statistics.collectFrom(exchangesList.get(i));
        }
        return statistics;
    }

    @Override
    public synchronized Object[] getAllExchanges() {
        return this.exchanges.toArray(new AbstractExchange[0]);
    }

    @Override
    public synchronized List<AbstractExchange> getAllExchangesAsList() {
        LinkedList<AbstractExchange> ret = new LinkedList<AbstractExchange>();
        for (Map.Entry<AbstractExchange, Request> entry : this.inflight.entrySet()) {
            AbstractExchange ex = entry.getKey();
            Request req = entry.getValue();
            Exchange newEx = new Exchange(null);
            newEx.setId(ex.getId());
            newEx.setRequest(req);
            newEx.setRule(ex.getRule());
            newEx.setRemoteAddr(ex.getRemoteAddr());
            newEx.setTime(ex.getTime());
            newEx.setTimeReqSent(ex.getTimeReqSent() != 0L ? ex.getTimeReqSent() : ex.getTimeReqReceived());
            newEx.setTimeResReceived(System.currentTimeMillis());
            ret.add(newEx);
        }
        ret.addAll(this.exchanges);
        return ret;
    }

    @Override
    public synchronized void removeAllExchanges(AbstractExchange[] candidates) {
        this.exchanges.removeAll(Arrays.asList(candidates));
        this.modify();
    }

    @Override
    public synchronized AbstractExchange getExchangeById(int id) {
        for (AbstractExchange exc : this.getAllExchangesAsList()) {
            if (exc.hashCode() != id) continue;
            return exc;
        }
        for (AbstractExchange exc : this.inflight.keySet()) {
            if (exc.hashCode() != id) continue;
            return exc;
        }
        return null;
    }

    @Override
    public synchronized List<? extends ClientStatistics> getClientStatistics() {
        HashMap<String, ClientStatisticsCollector> clients = new HashMap<String, ClientStatisticsCollector>();
        for (AbstractExchange exc : this.getAllExchangesAsList()) {
            if (!clients.containsKey(exc.getRemoteAddr())) {
                clients.put(exc.getRemoteAddr(), new ClientStatisticsCollector(exc.getRemoteAddr()));
            }
            ((ClientStatisticsCollector)clients.get(exc.getRemoteAddr())).collect(exc);
        }
        return new ArrayList(clients.values());
    }

    public synchronized int getCurrentSize() {
        return this.currentSize;
    }

    public synchronized Long getOldestTimeResSent() {
        AbstractExchange exc = this.exchanges.peek();
        return exc == null ? null : Long.valueOf(exc.getTimeResSent());
    }

    private void makeSpaceIfNeeded(AbstractExchange exc) {
        while (!this.hasEnoughSpace(exc)) {
            this.currentSize -= this.exchanges.poll().getHeapSizeEstimation();
        }
    }

    private boolean hasEnoughSpace(AbstractExchange exc) {
        return exc.getHeapSizeEstimation() + this.currentSize <= this.maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @MCAttribute
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        if ((long)this.maxSize > Runtime.getRuntime().totalMemory() - 0x6400000L) {
            this.showWarningNotEnoughMemory();
        }
    }

    private void showWarningNotEnoughMemory() {
        String seperator = "=========================================================================================";
        log.warn(seperator);
        log.warn(seperator);
        log.warn("You current LimitedMemoryExchangeStore max size is near the max available JVM heap space.");
        log.warn("LimitedMemoryExchangeStore max size: " + this.formatTwoDecimals(this.getLmesMaxSizeInMb()) + "mb");
        log.warn("Java Virtual Machine heap size: " + this.formatTwoDecimals(this.getJvmHeapSizeInMb()) + "mb");
        log.warn("Suggestion: add \"-Xmx" + Math.round(this.getLmesMaxSizeInMb() + 100.0f + 1.0f) + "m\" as additional parameter in the Membrane starter script");
        log.warn(seperator);
        log.warn(seperator);
    }

    private float getJvmHeapSizeInMb() {
        return (float)Runtime.getRuntime().totalMemory() / 1024.0f / 1024.0f;
    }

    private float getLmesMaxSizeInMb() {
        return (float)this.maxSize / 1024.0f / 1024.0f;
    }

    private String formatTwoDecimals(float number) {
        DecimalFormat formatter = new DecimalFormat("#.##");
        return formatter.format(number);
    }

    private synchronized void modify() {
        this.lastModification = System.currentTimeMillis();
        this.notifyAll();
    }

    @Override
    public synchronized long getLastModified() {
        return this.lastModification;
    }

    @Override
    public synchronized void waitForModification(long lastKnownModification) throws InterruptedException {
        while (lastKnownModification >= this.lastModification) {
            this.wait();
        }
        return;
    }
}

