/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchangestore;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchangestore.AbstractExchangeStore;
import com.predic8.membrane.core.exchangestore.DepthWalker;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.MessageObserver;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.RuleKey;
import com.predic8.membrane.core.rules.StatisticCollector;
import com.predic8.membrane.core.util.TextUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

@MCElement(name="fileExchangeStore")
public class FileExchangeStore
extends AbstractExchangeStore {
    private static Logger log = LoggerFactory.getLogger((String)FileExchangeStore.class.getName());
    private static AtomicInteger counter = new AtomicInteger();
    private static final String DATE_FORMAT = "'h'HH'm'mm's'ss'ms'SSS";
    private static final ThreadLocal<DateFormat> dateFormat = new ThreadLocal();
    private static final String separator = System.getProperty("file.separator");
    public static final String MESSAGE_FILE_PATH = "message.file.path";
    private String dir;
    private File directory;
    private boolean raw = false;
    private boolean saveBodyOnly = false;
    private int maxDays = -1;
    private Timer oldFilesCleanupTimer;

    @Override
    public void snap(final AbstractExchange exc, final Interceptor.Flow flow) {
        try {
            Message m;
            Message message = m = flow == Interceptor.Flow.REQUEST ? exc.getRequest() : exc.getResponse();
            if (m != null) {
                m.addObserver(new MessageObserver(){

                    @Override
                    public void bodyRequested(AbstractBody body) {
                    }

                    @Override
                    public void bodyComplete(AbstractBody body) {
                        FileExchangeStore.this.snapInternal(exc, flow);
                    }
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void snapInternal(AbstractExchange exc, Interceptor.Flow flow) {
        int fileNumber = counter.incrementAndGet();
        StringBuilder buf = this.getDirectoryNameBuffer(exc.getTime());
        this.directory = new File(buf.toString());
        this.directory.mkdirs();
        if (this.directory.exists() && this.directory.isDirectory()) {
            buf.append(separator);
            buf.append(FileExchangeStore.getDateFormat().format(exc.getTime().getTime()));
            buf.append("-");
            buf.append(fileNumber);
            exc.setProperty(MESSAGE_FILE_PATH, buf.toString());
            buf.append("-");
            StringBuilder buf2 = new StringBuilder(buf);
            buf.append("Request.msg");
            buf2.append("Response.msg");
            try {
                switch (flow) {
                    case REQUEST: {
                        this.writeFile(exc.getRequest(), buf.toString());
                        break;
                    }
                    case ABORT: 
                    case RESPONSE: {
                        if (exc.getResponse() == null) break;
                        this.writeFile(exc.getResponse(), buf2.toString());
                    }
                }
            }
            catch (Exception e) {
                log.error("{}", (Object)e, (Object)e);
            }
        } else {
            log.error("Directory does not exists or file is not a directory: " + buf.toString());
        }
    }

    private StringBuilder getDirectoryNameBuffer(Calendar time) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.dir);
        buf.append(separator);
        buf.append(time.get(1));
        buf.append(separator);
        buf.append(time.get(2) + 1);
        buf.append(separator);
        buf.append(time.get(5));
        return buf;
    }

    private static DateFormat getDateFormat() {
        DateFormat df = dateFormat.get();
        if (df == null) {
            df = new SimpleDateFormat(DATE_FORMAT);
            dateFormat.set(df);
        }
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(Message msg, String path) throws Exception {
        File file = new File(path);
        file.createNewFile();
        try (FileOutputStream os = new FileOutputStream(file);){
            if (this.raw || !this.saveBodyOnly) {
                msg.writeStartLine(os);
                msg.getHeader().write(os);
                os.write(Constants.CRLF_BYTES);
            }
            if (msg.isBodyEmpty()) {
                return;
            }
            if (this.raw) {
                os.write(msg.getBody().getRaw());
            } else if (msg.isXML()) {
                os.write(TextUtil.formatXML(new InputStreamReader(msg.getBodyAsStream(), msg.getHeader().getCharset())).getBytes("UTF-8"));
            } else {
                os.write(msg.getBody().getContent());
            }
        }
    }

    public void initializeTimer() {
        if (this.maxDays < 0) {
            return;
        }
        this.oldFilesCleanupTimer = new Timer("Clean up old log files", true);
        Calendar firstRun = Calendar.getInstance();
        firstRun.set(11, 3);
        firstRun.set(12, 14);
        if (firstRun.before(Calendar.getInstance())) {
            firstRun.add(5, 1);
        }
        this.oldFilesCleanupTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    FileExchangeStore.this.deleteOldFolders(Calendar.getInstance());
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }, firstRun.getTime(), 86400000L);
    }

    public void deleteOldFolders(Calendar now) throws IOException {
        if (this.maxDays < 0) {
            return;
        }
        Calendar threshold = now;
        threshold.add(5, -this.maxDays);
        ArrayList<File> folders3 = new DepthWalker(3).getDirectories(new File(this.dir));
        ArrayList<File> deletion = new ArrayList<File>();
        for (File f : folders3) {
            int day = Integer.parseInt(f.getName());
            int mon = Integer.parseInt(f.getParentFile().getName());
            int year = Integer.parseInt(f.getParentFile().getParentFile().getName());
            Calendar folderTime = Calendar.getInstance();
            folderTime.clear();
            folderTime.set(year, mon - 1, day);
            if (!folderTime.before(threshold)) continue;
            deletion.add(f);
        }
        for (File d : deletion) {
            FileUtils.deleteDirectory((File)d);
        }
    }

    @Override
    public AbstractExchange[] getExchanges(RuleKey ruleKey) {
        throw new RuntimeException("Method getExchanges() is not supported by FileExchangeStore");
    }

    @Override
    public int getNumberOfExchanges(RuleKey ruleKey) {
        throw new RuntimeException("Method getNumberOfExchanges() is not supported by FileExchangeStore");
    }

    @Override
    public void remove(AbstractExchange exchange) {
        throw new RuntimeException("Method remove() is not supported by FileExchangeStore");
    }

    @Override
    public void removeAllExchanges(Rule rule) {
        throw new RuntimeException("Method removeAllExchanges() is not supported by FileExchangeStore");
    }

    @Override
    public StatisticCollector getStatistics(RuleKey ruleKey) {
        return null;
    }

    @Override
    public Object[] getAllExchanges() {
        return null;
    }

    public Object[] getLatExchanges(int count) {
        return null;
    }

    @Override
    public List<AbstractExchange> getAllExchangesAsList() {
        return null;
    }

    @Override
    public void removeAllExchanges(AbstractExchange[] exchanges) {
    }

    public String getDir() {
        return this.dir;
    }

    @Required
    @MCAttribute
    public void setDir(String dir) {
        this.dir = dir;
    }

    public boolean isRaw() {
        return this.raw;
    }

    @MCAttribute
    public void setRaw(boolean raw) {
        this.raw = raw;
    }

    public boolean isSaveBodyOnly() {
        return this.saveBodyOnly;
    }

    @MCAttribute
    public void setSaveBodyOnly(boolean saveBodyOnly) {
        this.saveBodyOnly = saveBodyOnly;
    }

    public int getMaxDays() {
        return this.maxDays;
    }

    @MCAttribute
    public void setMaxDays(int maxDays) {
        this.maxDays = maxDays;
    }
}

