/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchangestore;

import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchangestore.ClientStatistics;
import com.predic8.membrane.core.exchangestore.ExchangeCollector;
import com.predic8.membrane.core.exchangestore.ExchangeStore;
import com.predic8.membrane.core.model.IExchangesStoreListener;
import com.predic8.membrane.core.rules.Rule;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractExchangeStore
implements ExchangeStore {
    protected Set<IExchangesStoreListener> exchangesStoreListeners = new HashSet<IExchangesStoreListener>();

    @Override
    public void addExchangesStoreListener(IExchangesStoreListener viewer) {
        this.exchangesStoreListeners.add(viewer);
    }

    @Override
    public void removeExchangesStoreListener(IExchangesStoreListener viewer) {
        this.exchangesStoreListeners.remove(viewer);
    }

    @Override
    public void refreshExchangeStoreListeners() {
        for (IExchangesStoreListener listener : this.exchangesStoreListeners) {
            listener.refresh();
        }
    }

    @Override
    public void notifyListenersOnExchangeAdd(Rule rule, AbstractExchange exchange) {
        for (IExchangesStoreListener listener : this.exchangesStoreListeners) {
            exchange.addExchangeStoreListener(listener);
            listener.addExchange(rule, exchange);
        }
    }

    @Override
    public void notifyListenersOnExchangeRemoval(AbstractExchange exchange) {
        for (IExchangesStoreListener listener : this.exchangesStoreListeners) {
            exchange.removeExchangeStoreListener(listener);
            listener.removeExchange(exchange);
        }
    }

    @Override
    public AbstractExchange getExchangeById(int id) {
        throw new UnsupportedOperationException("getExchangeById must be implemented in the sub class.");
    }

    @Override
    public List<? extends ClientStatistics> getClientStatistics() {
        throw new UnsupportedOperationException("getClientStatistics must be implemented in the sub class.");
    }

    @Override
    public void init() {
    }

    @Override
    public synchronized void collect(ExchangeCollector collector) {
        for (AbstractExchange exc : this.getAllExchangesAsList()) {
            collector.collect(exc);
        }
    }

    @Override
    public long getLastModified() {
        return System.currentTimeMillis();
    }

    @Override
    public void waitForModification(long lastKnownModification) throws InterruptedException {
    }
}

