/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchange;

import com.predic8.membrane.core.exchange.AbstractExchange;
import java.text.SimpleDateFormat;

public class ExchangesUtil {
    public static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String extractContentTypeValue(String contentType) {
        if (contentType == null) {
            return "";
        }
        int index = contentType.indexOf(";");
        if (index > 0) {
            return contentType.substring(0, index);
        }
        return contentType;
    }

    public static String getStatusCode(AbstractExchange exc) {
        if (exc.getResponse() == null) {
            return "";
        }
        return "" + exc.getResponse().getStatusCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTime(AbstractExchange exc) {
        if (exc.getTime() == null) {
            return "unknown";
        }
        SimpleDateFormat simpleDateFormat = DATE_FORMATTER;
        synchronized (simpleDateFormat) {
            return DATE_FORMATTER.format(exc.getTime().getTime());
        }
    }

    public static String getRequestContentLength(AbstractExchange exc) {
        if (exc.getRequestContentLength() == -1) {
            return "unknown";
        }
        return "" + exc.getRequestContentLength();
    }

    public static String getResponseContentLength(AbstractExchange exc) {
        if (exc.getResponseContentLength() == -1) {
            return "unknown";
        }
        return "" + exc.getResponseContentLength();
    }

    public static String getResponseContentType(AbstractExchange exc) {
        if (exc.getResponse() == null) {
            return "N/A";
        }
        return exc.getResponseContentType();
    }

    public static String getTimeDifference(AbstractExchange exc) {
        return "" + (exc.getTimeResReceived() - exc.getTimeReqSent());
    }
}

