/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.beautifier;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;

public class JSONBeautifier {
    private ObjectMapper objectMapper = new ObjectMapper();
    private boolean indentOutput = true;
    private boolean allowedUnquotedFieldNames = true;
    private boolean quoteFieldNames = false;
    private boolean failOnUnknownProperties = true;

    public String beautify(String content) throws IOException {
        JsonNode tree = this.objectMapper.readTree(content);
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)tree);
    }

    public void configure() {
        this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, this.indentOutput);
        this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, this.allowedUnquotedFieldNames);
        this.objectMapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, this.quoteFieldNames);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, this.failOnUnknownProperties);
    }

    public void setIndentOutput(boolean indentOutput) {
        this.indentOutput = indentOutput;
    }

    public void setAllowedUnquotedFieldNames(boolean allowedUnquotedFieldNames) {
        this.allowedUnquotedFieldNames = allowedUnquotedFieldNames;
    }

    public void setQuoteFieldNames(boolean quoteFieldNames) {
        this.quoteFieldNames = quoteFieldNames;
    }

    public void setFailOnUnknownProperties(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }
}

