/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.ConfigurationException;
import com.predic8.membrane.core.exchangestore.ExchangeStore;
import com.predic8.membrane.core.model.IExchangesStoreListener;
import com.predic8.membrane.core.model.IRuleChangeListener;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.RuleKey;
import com.predic8.membrane.core.transport.http.IpPort;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.SSLContextCollection;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleManager {
    private static Logger log = LoggerFactory.getLogger((String)RuleManager.class.getName());
    private Router router;
    private List<Rule> rules = new Vector<Rule>();
    private List<RuleDefinitionSource> ruleSources = new ArrayList<RuleDefinitionSource>();
    private Set<IRuleChangeListener> listeners = new HashSet<IRuleChangeListener>();
    private String defaultTargetHost = "localhost";
    private String defaultHost = "*";
    private int defaultListenPort = 2000;
    private int defaultTargetPort = 8080;
    private String defaultPath = ".*";
    private int defaultMethod = 4;

    public int getDefaultListenPort() {
        return this.defaultListenPort;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public String getDefaultPath() {
        return this.defaultPath;
    }

    public int getDefaultMethod() {
        return this.defaultMethod;
    }

    public void setDefaultMethod(int defaultMethod) {
        this.defaultMethod = defaultMethod;
    }

    public String getDefaultTargetHost() {
        return this.defaultTargetHost;
    }

    public void setDefaultTargetHost(String defaultTargetHost) {
        this.defaultTargetHost = defaultTargetHost;
    }

    public int getDefaultTargetPort() {
        return this.defaultTargetPort;
    }

    public boolean isAnyRuleWithPort(int port) {
        for (Rule rule : this.rules) {
            if (rule.getKey().getPort() != port) continue;
            return true;
        }
        return false;
    }

    public void addProxyAndOpenPortIfNew(Rule rule) throws IOException {
        this.addProxyAndOpenPortIfNew(rule, RuleDefinitionSource.MANUAL);
    }

    public synchronized void addProxyAndOpenPortIfNew(Rule rule, RuleDefinitionSource source) throws IOException {
        if (this.exists(rule.getKey())) {
            return;
        }
        this.router.getTransport().openPort(rule.getKey().getIp(), rule.getKey().getPort(), rule.getSslInboundContext());
        this.rules.add(rule);
        this.ruleSources.add(source);
        for (IRuleChangeListener listener : this.listeners) {
            listener.ruleAdded(rule);
        }
    }

    public synchronized void addProxy(Rule rule, RuleDefinitionSource source) {
        if (this.exists(rule.getKey())) {
            return;
        }
        this.rules.add(rule);
        this.ruleSources.add(source);
        for (IRuleChangeListener listener : this.listeners) {
            listener.ruleAdded(rule);
        }
    }

    public synchronized void openPorts() throws IOException {
        HashMap sslProviders;
        try {
            HashMap<IpPort, SSLContextCollection.Builder> sslContexts = new HashMap<IpPort, SSLContextCollection.Builder>();
            for (Rule rule : this.rules) {
                SSLContext sslContext = rule.getSslInboundContext();
                if (sslContext == null) continue;
                IpPort ipPort = new IpPort(rule.getKey().getIp(), rule.getKey().getPort());
                SSLContextCollection.Builder builder = (SSLContextCollection.Builder)sslContexts.get(ipPort);
                if (builder == null) {
                    builder = new SSLContextCollection.Builder();
                    sslContexts.put(ipPort, builder);
                }
                builder.add(sslContext);
            }
            sslProviders = new HashMap();
            for (Map.Entry entry : sslContexts.entrySet()) {
                sslProviders.put(entry.getKey(), ((SSLContextCollection.Builder)entry.getValue()).build());
            }
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        for (Rule rule : this.rules) {
            IpPort ipPort = new IpPort(rule.getKey().getIp(), rule.getKey().getPort());
            this.router.getTransport().openPort(rule.getKey().getIp(), rule.getKey().getPort(), (SSLProvider)sslProviders.get(ipPort));
        }
    }

    public boolean exists(RuleKey key) {
        return this.getRule(key) != null;
    }

    private Rule getRule(RuleKey key) {
        for (Rule r : this.rules) {
            if (!r.getKey().equals(key)) continue;
            return r;
        }
        return null;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public synchronized void ruleUp(Rule rule) {
        int index = this.rules.indexOf(rule);
        if (index <= 0) {
            return;
        }
        Collections.swap(this.rules, index, index - 1);
        Collections.swap(this.ruleSources, index, index - 1);
        for (IRuleChangeListener listener : this.listeners) {
            listener.rulePositionsChanged();
        }
    }

    public synchronized void ruleDown(Rule rule) {
        int index = this.rules.indexOf(rule);
        if (index < 0 || index == this.rules.size() - 1) {
            return;
        }
        Collections.swap(this.rules, index, index + 1);
        Collections.swap(this.ruleSources, index, index + 1);
        for (IRuleChangeListener listener : this.listeners) {
            listener.rulePositionsChanged();
        }
    }

    public void ruleChanged(Rule rule) {
        for (IRuleChangeListener listener : this.listeners) {
            listener.ruleUpdated(rule);
        }
        this.getExchangeStore().refreshExchangeStoreListeners();
    }

    public Rule getMatchingRule(String hostHeader, String method, String uri, String version, int port, String localIP) {
        for (Rule rule : this.rules) {
            RuleKey key = rule.getKey();
            log.debug("Host from rule: " + key.getHost() + ";   Host from parameter rule key: " + hostHeader);
            if (!rule.isActive() || !key.matchesVersion(version) || key.getIp() != null && !key.getIp().equals(localIP) || !key.matchesHostHeader(hostHeader) || key.getPort() != -1 && port != -1 && key.getPort() != port || !key.getMethod().equals(method) && !key.isMethodWildcard() || key.isUsePathPattern() && !key.matchesPath(uri) || !key.complexMatch(hostHeader, method, uri, version, port, localIP)) continue;
            return rule;
        }
        return null;
    }

    public void addRuleChangeListener(IRuleChangeListener viewer) {
        this.listeners.add(viewer);
        viewer.batchUpdate(this.rules.size());
    }

    public void removeRuleChangeListener(IRuleChangeListener viewer) {
        this.listeners.remove(viewer);
    }

    public void addExchangesStoreListener(IExchangesStoreListener viewer) {
        this.getExchangeStore().addExchangesStoreListener(viewer);
    }

    public void removeExchangesStoreListener(IExchangesStoreListener viewer) {
        this.getExchangeStore().removeExchangesStoreListener(viewer);
    }

    public synchronized void removeRule(Rule rule) {
        this.getExchangeStore().removeAllExchanges(rule);
        int i = this.rules.indexOf(rule);
        this.rules.remove(i);
        this.ruleSources.remove(i);
        for (IRuleChangeListener listener : this.listeners) {
            listener.ruleRemoved(rule, this.rules.size());
        }
    }

    public synchronized void replaceRule(Rule rule, Rule newRule) {
        this.getExchangeStore().removeAllExchanges(rule);
        int i = this.rules.indexOf(rule);
        this.rules.set(i, newRule);
        for (IRuleChangeListener listener : this.listeners) {
            listener.ruleRemoved(rule, this.rules.size());
        }
        for (IRuleChangeListener listener : this.listeners) {
            listener.ruleAdded(newRule);
        }
    }

    public synchronized void removeRulesFromSource(RuleDefinitionSource source) {
        for (int i = 0; i < this.rules.size(); ++i) {
            if (this.ruleSources.get(i) != source) continue;
            this.removeRule(this.rules.get(i--));
        }
    }

    public synchronized void removeAllRules() {
        while (this.rules.size() > 0) {
            this.removeRule(this.rules.get(0));
        }
    }

    public synchronized int getNumberOfRules() {
        return this.rules.size();
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    private ExchangeStore getExchangeStore() {
        return this.router.getExchangeStore();
    }

    public Rule getRuleByName(String name) {
        for (Rule r : this.rules) {
            if (!name.equals(r.getName())) continue;
            return r;
        }
        return null;
    }

    public synchronized List<Rule> getRulesBySource(final RuleDefinitionSource source) {
        ArrayList<Rule> res = new ArrayList<Rule>(){
            private static final long serialVersionUID = 1L;
            {
                for (int i = 0; i < RuleManager.this.rules.size(); ++i) {
                    if (RuleManager.this.ruleSources.get(i) != source) continue;
                    this.add((Rule)RuleManager.this.rules.get(i));
                }
            }

            @Override
            public Rule set(int index, Rule element) {
                throw new IllegalStateException("set(int, Rule) is not allowed");
            }

            @Override
            public boolean add(Rule e) {
                RuleManager.this.addProxy(e, source);
                return super.add(e);
            }

            @Override
            public void add(int index, Rule e) {
                RuleManager.this.addProxy(e, source);
                super.add(index, e);
            }
        };
        return res;
    }

    public static enum RuleDefinitionSource {
        SPRING,
        MANUAL;

    }
}

